/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.utils;

import java.util.Date;
import java.util.List;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.models.SMSValue;
import org.hisp.dhis.smscompression.utils.BinaryUtils;
import org.hisp.dhis.smscompression.utils.BitInputStream;
import org.hisp.dhis.smscompression.utils.BitOutputStream;

public class ValueUtil {
    public static void writeSMSValue(SMSValue<?> val, int fixedIntBitlen, BitOutputStream outStream) throws SMSCompressionException {
        outStream.write(val.getType().ordinal(), 3);
        switch (val.getType()) {
            case BOOL: {
                ValueUtil.writeBool((Boolean)val.getValue(), outStream);
                break;
            }
            case DATE: {
                ValueUtil.writeDate((Date)val.getValue(), outStream);
                break;
            }
            case INT: {
                ValueUtil.writeInt((Integer)val.getValue(), fixedIntBitlen, outStream);
                break;
            }
            case FLOAT: {
                ValueUtil.writeFloat(((Float)val.getValue()).floatValue(), outStream);
                break;
            }
            default: {
                ValueUtil.writeString((String)val.getValue(), outStream);
            }
        }
    }

    public static SMSValue<?> readSMSValue(int fixedIntBitLen, BitInputStream inStream) throws SMSCompressionException {
        int typeNum = inStream.read(3);
        SMSConsts.ValueType type = SMSConsts.ValueType.values()[typeNum];
        switch (type) {
            case BOOL: {
                return new SMSValue<Boolean>(ValueUtil.readBool(inStream), type);
            }
            case DATE: {
                return new SMSValue<Date>(ValueUtil.readDate(inStream), type);
            }
            case INT: {
                return new SMSValue<Integer>(ValueUtil.readInt(fixedIntBitLen, inStream), type);
            }
            case FLOAT: {
                return new SMSValue<Float>(Float.valueOf(ValueUtil.readFloat(inStream)), type);
            }
            case STRING: {
                return new SMSValue<String>(ValueUtil.readString(inStream), type);
            }
        }
        throw new SMSCompressionException("Unknown ValueType: " + (Object)((Object)type));
    }

    public static void writeBool(boolean val, BitOutputStream outStream) throws SMSCompressionException {
        int intVal = val ? 1 : 0;
        outStream.write(intVal, 1);
    }

    public static boolean readBool(BitInputStream inStream) throws SMSCompressionException {
        int intVal = inStream.read(1);
        return intVal == 1;
    }

    public static void writeDate(Date d, BitOutputStream outStream) throws SMSCompressionException {
        long epochSecs = d.getTime() / 1000L;
        outStream.write((int)epochSecs, 32);
    }

    public static Date readDate(BitInputStream inStream) throws SMSCompressionException {
        long epochSecs = inStream.read(32);
        Date dateVal = new Date(epochSecs * 1000L);
        return dateVal;
    }

    public static void writeInt(int val, int fixedIntBitlen, BitOutputStream outStream) throws SMSCompressionException {
        int isNegative = val < 0 ? 1 : 0;
        outStream.write(isNegative, 1);
        val = Math.abs(val);
        int isVariable = val > SMSConsts.MAX_FIXED_NUM ? 1 : 0;
        outStream.write(isVariable, 1);
        int intBitlen = BinaryUtils.bitlenNeeded(val);
        if (isVariable == 1) {
            outStream.write(intBitlen, 6);
        }
        int bitLen = isVariable == 1 ? intBitlen : fixedIntBitlen;
        outStream.write(val, bitLen);
    }

    public static int readInt(int fixedIntBitlen, BitInputStream inStream) throws SMSCompressionException {
        int setNegative = inStream.read(1) == 1 ? -1 : 1;
        int isVariable = inStream.read(1);
        int bitLen = isVariable == 1 ? inStream.read(6) : fixedIntBitlen;
        return setNegative * inStream.read(bitLen);
    }

    public static void writeFloat(float val, BitOutputStream outStream) throws SMSCompressionException {
        ValueUtil.writeString(Float.toString(val), outStream);
    }

    public static float readFloat(BitInputStream inStream) throws SMSCompressionException {
        return Float.parseFloat(ValueUtil.readString(inStream));
    }

    public static void writeString(String s, BitOutputStream outStream) throws SMSCompressionException {
        for (char c : s.toCharArray()) {
            outStream.write(c, 8);
        }
        outStream.write(0, 8);
    }

    public static String readString(BitInputStream inStream) throws SMSCompressionException {
        int i;
        String s = "";
        while ((i = inStream.read(8)) != 0) {
            s = s + (char)i;
        }
        return s;
    }

    public static int getBitlenLargestInt(List<SMSValue<?>> values) {
        int maxInt = 0;
        for (SMSValue<?> val : values) {
            int intVal;
            if (val.getType() != SMSConsts.ValueType.INT || (intVal = Math.abs((Integer)val.getValue())) > SMSConsts.MAX_FIXED_NUM) continue;
            maxInt = intVal > maxInt ? intVal : maxInt;
        }
        return BinaryUtils.bitlenNeeded(maxInt);
    }
}

