/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.utils;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.hisp.dhis.smscompression.SMSCompressionException;

public final class BitInputStream
implements AutoCloseable {
    private InputStream input;
    private int currentByte;
    private int numBitsRemaining;

    public BitInputStream(InputStream in) {
        Objects.requireNonNull(in);
        this.input = in;
        this.currentByte = 0;
        this.numBitsRemaining = 0;
    }

    public int readBit() throws IOException {
        if (this.currentByte == -1) {
            return -1;
        }
        if (this.numBitsRemaining == 0) {
            this.currentByte = this.input.read();
            if (this.currentByte == -1) {
                return -1;
            }
            this.numBitsRemaining = 8;
        }
        if (this.numBitsRemaining <= 0) {
            throw new AssertionError();
        }
        --this.numBitsRemaining;
        return this.currentByte >>> this.numBitsRemaining & 1;
    }

    public int read(int n) throws SMSCompressionException {
        try {
            int i = 0;
            while (n > 0) {
                i <<= 1;
                i |= this.readBitEof();
                --n;
            }
            return i;
        }
        catch (IOException e) {
            throw new SMSCompressionException(e);
        }
    }

    public int readBitEof() throws IOException {
        int result = this.readBit();
        if (result != -1) {
            return result;
        }
        throw new EOFException();
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        this.currentByte = -1;
        this.numBitsRemaining = 0;
    }
}

