/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.models;

import java.util.Date;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.SMSSubmissionReader;
import org.hisp.dhis.smscompression.SMSSubmissionWriter;

public class SMSSubmissionHeader {
    protected SMSConsts.SubmissionType type;
    protected int version;
    protected Date lastSyncDate;
    protected int submissionID;

    public int getSubmissionID() {
        return this.submissionID;
    }

    public void setSubmissionID(int submissionID) {
        this.submissionID = submissionID;
    }

    public SMSConsts.SubmissionType getType() {
        return this.type;
    }

    public void setType(SMSConsts.SubmissionType type) {
        this.type = type;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Date getLastSyncDate() {
        return this.lastSyncDate;
    }

    public void setLastSyncDate(Date lastSyncDate) {
        this.lastSyncDate = lastSyncDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMSSubmissionHeader hdr = (SMSSubmissionHeader)o;
        return this.type.equals((Object)hdr.type) && this.version == hdr.version && this.lastSyncDate.equals(hdr.lastSyncDate) && this.submissionID == hdr.submissionID;
    }

    public void validateHeaer() throws SMSCompressionException {
        if (this.submissionID < 0 || this.submissionID > 255) {
            throw new SMSCompressionException("Ensure the Submission ID has been set for this submission");
        }
    }

    public void writeHeader(SMSSubmissionWriter writer) throws SMSCompressionException {
        writer.writeType(this.type);
        writer.writeVersion(this.version);
        writer.writeNonNullableDate(this.lastSyncDate);
        writer.writeSubmissionID(this.submissionID);
    }

    public void readHeader(SMSSubmissionReader reader) throws SMSCompressionException {
        this.type = reader.readType();
        this.version = reader.readVersion();
        this.lastSyncDate = reader.readNonNullableDate();
        this.submissionID = reader.readSubmissionID();
    }
}

