/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.models;

import java.util.Date;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.SMSSubmissionReader;
import org.hisp.dhis.smscompression.SMSSubmissionWriter;
import org.hisp.dhis.smscompression.models.SMSMetadata;
import org.hisp.dhis.smscompression.models.SMSSubmissionHeader;
import org.hisp.dhis.smscompression.models.UID;

public abstract class SMSSubmission {
    protected SMSSubmissionHeader header = new SMSSubmissionHeader();
    protected UID userID;

    public abstract int getCurrentVersion();

    public abstract SMSConsts.SubmissionType getType();

    public abstract void writeSubm(SMSSubmissionWriter var1, int var2) throws SMSCompressionException;

    public abstract void readSubm(SMSSubmissionReader var1, int var2) throws SMSCompressionException;

    public SMSSubmission() {
        this.header.setType(this.getType());
        this.header.setSubmissionID(-1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMSSubmission subm = (SMSSubmission)o;
        return this.userID.equals(subm.userID) && this.header.equals(subm.header);
    }

    public void setSubmissionID(int submissionID) {
        this.header.setSubmissionID(submissionID);
    }

    public UID getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = new UID(userID, SMSConsts.MetadataType.USER);
    }

    public void validateSubmission() throws SMSCompressionException {
        this.header.validateHeaer();
        if (this.userID.uid.isEmpty()) {
            throw new SMSCompressionException("Ensure the UserID is set in the submission");
        }
    }

    public void write(SMSMetadata meta, SMSSubmissionWriter writer, int version) throws SMSCompressionException {
        Date lastSyncDate = meta != null && meta.lastSyncDate != null ? meta.lastSyncDate : new Date(0L);
        this.header.setLastSyncDate(lastSyncDate);
        this.validateSubmission();
        this.header.setVersion(version);
        this.header.writeHeader(writer);
        writer.writeID(this.userID);
        this.writeSubm(writer, version);
    }

    public void read(SMSSubmissionReader reader, SMSSubmissionHeader header) throws SMSCompressionException {
        this.header = header;
        this.userID = reader.readID(SMSConsts.MetadataType.USER);
        this.readSubm(reader, this.header.getVersion());
    }

    protected String versionError(int version) {
        return String.format("Version %d of %s is not supported", version, this.getClass().getSimpleName());
    }
}

