/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.models;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.utils.IDUtil;

public class SMSMetadata {
    public Date lastSyncDate;
    public List<ID> users;
    public List<ID> trackedEntityTypes;
    public List<ID> trackedEntityAttributes;
    public List<ID> programs;
    public List<ID> organisationUnits;
    public List<ID> dataElements;
    public List<ID> categoryOptionCombos;
    public List<ID> dataSets;
    public List<ID> programStages;
    public List<ID> events;
    public List<ID> enrollments;
    public List<ID> trackedEntityInstances;
    public List<ID> relationships;
    public List<ID> relationshipTypes;

    public void validate() throws SMSCompressionException {
        for (SMSConsts.MetadataType type : SMSConsts.MetadataType.values()) {
            SMSMetadata.checkIDList(this.getType(type), type);
        }
    }

    public static boolean checkIDList(List<String> ids, SMSConsts.MetadataType type) throws SMSCompressionException {
        String typeMsg = "Metadata error[" + (Object)((Object)type) + "]:";
        HashSet<String> set = new HashSet<String>();
        for (String id : ids) {
            if (!set.add(id)) {
                throw new SMSCompressionException(typeMsg + "List of UIDs in Metadata contains duplicate: " + id);
            }
            if (IDUtil.validID(id)) continue;
            throw new SMSCompressionException(typeMsg + "Invalid format UID found in Metadata UID List: " + id);
        }
        return true;
    }

    public List<String> getType(SMSConsts.MetadataType type) {
        switch (type) {
            case USER: {
                return this.getIDs(this.users);
            }
            case TRACKED_ENTITY_TYPE: {
                return this.getIDs(this.trackedEntityTypes);
            }
            case TRACKED_ENTITY_ATTRIBUTE: {
                return this.getIDs(this.trackedEntityAttributes);
            }
            case PROGRAM: {
                return this.getIDs(this.programs);
            }
            case ORGANISATION_UNIT: {
                return this.getIDs(this.organisationUnits);
            }
            case DATA_ELEMENT: {
                return this.getIDs(this.dataElements);
            }
            case CATEGORY_OPTION_COMBO: {
                return this.getIDs(this.categoryOptionCombos);
            }
            case DATASET: {
                return this.getIDs(this.dataSets);
            }
            case PROGRAM_STAGE: {
                return this.getIDs(this.programStages);
            }
            case EVENT: {
                return this.getIDs(this.events);
            }
            case ENROLLMENT: {
                return this.getIDs(this.enrollments);
            }
            case TRACKED_ENTITY_INSTANCE: {
                return this.getIDs(this.trackedEntityInstances);
            }
            case RELATIONSHIP: {
                return this.getIDs(this.relationships);
            }
            case RELATIONSHIP_TYPE: {
                return this.getIDs(this.relationshipTypes);
            }
        }
        return null;
    }

    private List<String> getIDs(List<ID> ids) {
        ArrayList<String> idList = new ArrayList<String>();
        if (ids != null) {
            for (ID id : ids) {
                idList.add(id.id);
            }
        }
        return idList;
    }

    public static class ID {
        String id;

        public ID(String id) {
            this.id = id;
        }
    }
}

