/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.models;

import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.models.SMSValue;
import org.hisp.dhis.smscompression.models.UID;

public class SMSAttributeValue {
    protected UID attribute;
    protected String value;
    protected SMSValue<?> smsValue;
    protected SMSConsts.ValueType type;

    public SMSAttributeValue(String attribute, String value) {
        this.attribute = new UID(attribute, SMSConsts.MetadataType.TRACKED_ENTITY_ATTRIBUTE);
        this.value = value;
        this.smsValue = SMSValue.asSMSValue(value);
    }

    public SMSAttributeValue(UID attribute, SMSValue<?> smsValue) {
        this.attribute = attribute;
        this.smsValue = smsValue;
        this.value = smsValue.getValue().toString();
    }

    public UID getAttribute() {
        return this.attribute;
    }

    public String getValue() {
        return this.value;
    }

    public SMSValue<?> getSMSValue() {
        return this.smsValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMSAttributeValue dv = (SMSAttributeValue)o;
        return this.attribute.equals(dv.attribute) && this.value.equals(dv.value);
    }

    public int hashCode() {
        return 0;
    }
}

