/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.models;

import java.util.Objects;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.SMSSubmissionReader;
import org.hisp.dhis.smscompression.SMSSubmissionWriter;
import org.hisp.dhis.smscompression.models.SMSSubmission;
import org.hisp.dhis.smscompression.models.UID;

public class RelationshipSMSSubmission
extends SMSSubmission {
    protected UID relationshipType;
    protected UID relationship;
    protected UID from;
    protected UID to;

    public UID getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(String relationshipType) {
        this.relationshipType = new UID(relationshipType, SMSConsts.MetadataType.RELATIONSHIP_TYPE);
    }

    public UID getRelationship() {
        return this.relationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = new UID(relationship, SMSConsts.MetadataType.RELATIONSHIP);
    }

    public UID getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = new UID(from, null);
    }

    public UID getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = new UID(to, null);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        RelationshipSMSSubmission subm = (RelationshipSMSSubmission)o;
        return Objects.equals(this.relationshipType, subm.relationshipType) && Objects.equals(this.relationship, subm.relationship) && Objects.equals(this.from, subm.from) && Objects.equals(this.to, subm.to);
    }

    @Override
    public void writeSubm(SMSSubmissionWriter writer, int version) throws SMSCompressionException {
        if (version != 1 && version != 2) {
            throw new SMSCompressionException(this.versionError(version));
        }
        writer.writeID(this.relationshipType);
        writer.writeID(this.relationship);
        writer.writeNewID(this.from.uid);
        writer.writeNewID(this.to.uid);
    }

    @Override
    public void readSubm(SMSSubmissionReader reader, int version) throws SMSCompressionException {
        if (version != 1 && version != 2) {
            throw new SMSCompressionException(this.versionError(version));
        }
        this.relationshipType = reader.readID(SMSConsts.MetadataType.RELATIONSHIP_TYPE);
        this.relationship = reader.readID(SMSConsts.MetadataType.RELATIONSHIP);
        this.from = new UID(reader.readNewID(), null);
        this.to = new UID(reader.readNewID(), null);
    }

    @Override
    public int getCurrentVersion() {
        return 2;
    }

    @Override
    public SMSConsts.SubmissionType getType() {
        return SMSConsts.SubmissionType.RELATIONSHIP;
    }
}

