/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression.models;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.SMSSubmissionReader;
import org.hisp.dhis.smscompression.SMSSubmissionWriter;
import org.hisp.dhis.smscompression.models.GeoPoint;
import org.hisp.dhis.smscompression.models.SMSAttributeValue;
import org.hisp.dhis.smscompression.models.SMSEvent;
import org.hisp.dhis.smscompression.models.SMSSubmission;
import org.hisp.dhis.smscompression.models.UID;

public class EnrollmentSMSSubmission
extends SMSSubmission {
    protected UID orgUnit;
    protected UID trackerProgram;
    protected UID trackedEntityType;
    protected UID trackedEntityInstance;
    protected UID enrollment;
    protected Date enrollmentDate;
    protected SMSConsts.SMSEnrollmentStatus enrollmentStatus;
    protected Date incidentDate;
    protected GeoPoint coordinates;
    protected List<SMSAttributeValue> values;
    protected List<SMSEvent> events;

    public UID getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(String orgUnit) {
        this.orgUnit = new UID(orgUnit, SMSConsts.MetadataType.ORGANISATION_UNIT);
    }

    public UID getTrackerProgram() {
        return this.trackerProgram;
    }

    public void setTrackerProgram(String trackerProgram) {
        this.trackerProgram = new UID(trackerProgram, SMSConsts.MetadataType.PROGRAM);
    }

    public UID getTrackedEntityType() {
        return this.trackedEntityType;
    }

    public void setTrackedEntityType(String trackedEntityType) {
        this.trackedEntityType = new UID(trackedEntityType, SMSConsts.MetadataType.TRACKED_ENTITY_TYPE);
    }

    public UID getTrackedEntityInstance() {
        return this.trackedEntityInstance;
    }

    public void setTrackedEntityInstance(String trackedEntityInstance) {
        this.trackedEntityInstance = new UID(trackedEntityInstance, SMSConsts.MetadataType.TRACKED_ENTITY_INSTANCE);
    }

    public UID getEnrollment() {
        return this.enrollment;
    }

    public void setEnrollment(String enrollment) {
        this.enrollment = new UID(enrollment, SMSConsts.MetadataType.ENROLLMENT);
    }

    public Date getEnrollmentDate() {
        return this.enrollmentDate;
    }

    public void setEnrollmentDate(Date enrollmentDate) {
        this.enrollmentDate = enrollmentDate;
    }

    public SMSConsts.SMSEnrollmentStatus getEnrollmentStatus() {
        return this.enrollmentStatus;
    }

    public void setEnrollmentStatus(SMSConsts.SMSEnrollmentStatus enrollmentStatus) {
        this.enrollmentStatus = enrollmentStatus;
    }

    public Date getIncidentDate() {
        return this.incidentDate;
    }

    public void setIncidentDate(Date incidentDate) {
        this.incidentDate = incidentDate;
    }

    public GeoPoint getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(GeoPoint coordinates) {
        this.coordinates = coordinates;
    }

    public List<SMSAttributeValue> getValues() {
        return this.values;
    }

    public void setValues(List<SMSAttributeValue> values) {
        this.values = values;
    }

    public List<SMSEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<SMSEvent> events) {
        this.events = events;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        EnrollmentSMSSubmission subm = (EnrollmentSMSSubmission)o;
        return Objects.equals(this.orgUnit, subm.orgUnit) && Objects.equals(this.trackerProgram, subm.trackerProgram) && Objects.equals(this.trackedEntityType, subm.trackedEntityType) && Objects.equals(this.trackedEntityInstance, subm.trackedEntityInstance) && Objects.equals(this.enrollment, subm.enrollment) && Objects.equals(this.enrollmentDate, subm.enrollmentDate) && Objects.equals((Object)this.enrollmentStatus, (Object)subm.enrollmentStatus) && Objects.equals(this.incidentDate, subm.incidentDate) && Objects.equals(this.coordinates, subm.coordinates) && Objects.equals(this.values, subm.values) && Objects.equals(this.events, subm.events);
    }

    @Override
    public void writeSubm(SMSSubmissionWriter writer, int version) throws SMSCompressionException {
        switch (version) {
            case 1: {
                this.writeSubmV1(writer, version);
                break;
            }
            case 2: {
                this.writeSubmV2(writer, version);
                break;
            }
            default: {
                throw new SMSCompressionException(this.versionError(version));
            }
        }
    }

    private void writeSubmV1(SMSSubmissionWriter writer, int version) throws SMSCompressionException {
        writer.writeID(this.orgUnit);
        writer.writeID(this.trackerProgram);
        writer.writeID(this.trackedEntityType);
        writer.writeID(this.trackedEntityInstance);
        writer.writeID(this.enrollment);
        writer.writeNonNullableDate(this.enrollmentDate);
        writer.writeAttributeValues(this.values);
    }

    private void writeSubmV2(SMSSubmissionWriter writer, int version) throws SMSCompressionException {
        writer.writeID(this.orgUnit);
        writer.writeID(this.trackerProgram);
        writer.writeID(this.trackedEntityType);
        writer.writeID(this.trackedEntityInstance);
        writer.writeID(this.enrollment);
        writer.writeDate(this.enrollmentDate);
        writer.writeEnrollmentStatus(this.enrollmentStatus);
        writer.writeDate(this.incidentDate);
        writer.writeGeoPoint(this.coordinates);
        boolean hasValues = this.values != null && !this.values.isEmpty();
        writer.writeBool(hasValues);
        if (hasValues) {
            writer.writeAttributeValues(this.values);
        }
        writer.writeEvents(this.events, version);
    }

    @Override
    public void readSubm(SMSSubmissionReader reader, int version) throws SMSCompressionException {
        switch (version) {
            case 1: {
                this.readSubmV1(reader, version);
                break;
            }
            case 2: {
                this.readSubmV2(reader, version);
                break;
            }
            default: {
                throw new SMSCompressionException(this.versionError(version));
            }
        }
    }

    public void readSubmV1(SMSSubmissionReader reader, int version) throws SMSCompressionException {
        this.orgUnit = reader.readID(SMSConsts.MetadataType.ORGANISATION_UNIT);
        this.trackerProgram = reader.readID(SMSConsts.MetadataType.PROGRAM);
        this.trackedEntityType = reader.readID(SMSConsts.MetadataType.TRACKED_ENTITY_TYPE);
        this.trackedEntityInstance = reader.readID(SMSConsts.MetadataType.TRACKED_ENTITY_INSTANCE);
        this.enrollment = reader.readID(SMSConsts.MetadataType.ENROLLMENT);
        this.enrollmentDate = reader.readNonNullableDate();
        this.values = reader.readAttributeValues();
        this.events = null;
    }

    public void readSubmV2(SMSSubmissionReader reader, int version) throws SMSCompressionException {
        this.orgUnit = reader.readID(SMSConsts.MetadataType.ORGANISATION_UNIT);
        this.trackerProgram = reader.readID(SMSConsts.MetadataType.PROGRAM);
        this.trackedEntityType = reader.readID(SMSConsts.MetadataType.TRACKED_ENTITY_TYPE);
        this.trackedEntityInstance = reader.readID(SMSConsts.MetadataType.TRACKED_ENTITY_INSTANCE);
        this.enrollment = reader.readID(SMSConsts.MetadataType.ENROLLMENT);
        this.enrollmentDate = reader.readDate();
        this.enrollmentStatus = reader.readEnrollmentStatus();
        this.incidentDate = reader.readDate();
        this.coordinates = reader.readGeoPoint();
        boolean hasValues = reader.readBool();
        this.values = hasValues ? reader.readAttributeValues() : null;
        this.events = reader.readEvents(version);
    }

    @Override
    public int getCurrentVersion() {
        return 2;
    }

    @Override
    public SMSConsts.SubmissionType getType() {
        return SMSConsts.SubmissionType.ENROLLMENT;
    }
}

