/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.models.SMSAttributeValue;
import org.hisp.dhis.smscompression.models.SMSDataValue;
import org.hisp.dhis.smscompression.models.SMSMetadata;
import org.hisp.dhis.smscompression.models.UID;
import org.hisp.dhis.smscompression.utils.BinaryUtils;
import org.hisp.dhis.smscompression.utils.BitOutputStream;
import org.hisp.dhis.smscompression.utils.IDUtil;
import org.hisp.dhis.smscompression.utils.ValueUtil;

public class ValueWriter {
    BitOutputStream outStream;
    SMSMetadata meta;
    boolean hashingEnabled;

    public ValueWriter(BitOutputStream outStream, SMSMetadata meta, boolean hashingEnabled) {
        this.outStream = outStream;
        this.meta = meta;
        this.hashingEnabled = hashingEnabled;
    }

    public int writeHashBitLen(SMSConsts.MetadataType type, boolean useHashing) throws SMSCompressionException {
        if (!useHashing) {
            return 0;
        }
        int hashBitLen = IDUtil.getBitLengthForList(this.meta.getType(type));
        this.outStream.write(hashBitLen, 6);
        return hashBitLen;
    }

    public void writeValID(UID uid, int bitLen, boolean useHashing) throws SMSCompressionException {
        if (!useHashing) {
            ValueUtil.writeString(uid.uid, this.outStream);
            return;
        }
        if (!this.meta.getType(uid.type).contains(uid.uid)) {
            throw new SMSCompressionException(String.format("Error hashing UID [%s] not found in [%s]", new Object[]{uid.uid, uid.type}));
        }
        int idHash = BinaryUtils.hash(uid.uid, bitLen);
        this.outStream.write(idHash, bitLen);
    }

    public void writeAttributeValues(List<SMSAttributeValue> values) throws SMSCompressionException {
        SMSConsts.MetadataType attrType = SMSConsts.MetadataType.TRACKED_ENTITY_ATTRIBUTE;
        boolean useHashing = this.hashingEnabled && this.meta != null && this.meta.getType(attrType) != null && !this.meta.getType(attrType).isEmpty();
        ValueUtil.writeBool(useHashing, this.outStream);
        int attributeBitLen = this.writeHashBitLen(attrType, useHashing);
        ArrayList smsVals = new ArrayList();
        for (SMSAttributeValue val : values) {
            smsVals.add(val.getSMSValue());
        }
        int fixedIntBitLen = ValueUtil.getBitlenLargestInt(smsVals);
        this.outStream.write(fixedIntBitLen - 1, 4);
        Iterator<SMSAttributeValue> valIter = values.iterator();
        while (valIter.hasNext()) {
            SMSAttributeValue val = valIter.next();
            this.writeValID(val.getAttribute(), attributeBitLen, useHashing);
            ValueUtil.writeSMSValue(val.getSMSValue(), fixedIntBitLen, this.outStream);
            int separator = valIter.hasNext() ? 1 : 0;
            this.outStream.write(separator, 1);
        }
    }

    public Map<UID, List<SMSDataValue>> groupDataValues(List<SMSDataValue> values) {
        HashMap<UID, List<SMSDataValue>> map = new HashMap<UID, List<SMSDataValue>>();
        for (SMSDataValue val : values) {
            List<Object> list;
            UID catOptionCombo = val.getCategoryOptionCombo();
            if (!map.containsKey(catOptionCombo)) {
                list = new ArrayList();
                map.put(catOptionCombo, list);
            }
            list = map.get(catOptionCombo);
            list.add(val);
        }
        return map;
    }

    public void writeDataValues(List<SMSDataValue> values) throws SMSCompressionException {
        SMSConsts.MetadataType cocType = SMSConsts.MetadataType.CATEGORY_OPTION_COMBO;
        SMSConsts.MetadataType deType = SMSConsts.MetadataType.DATA_ELEMENT;
        boolean useHashing = this.hashingEnabled && this.meta != null && this.meta.getType(cocType) != null && !this.meta.getType(cocType).isEmpty() && this.meta.getType(deType) != null && !this.meta.getType(deType).isEmpty();
        ValueUtil.writeBool(useHashing, this.outStream);
        int catOptionComboBitLen = this.writeHashBitLen(cocType, useHashing);
        int dataElementBitLen = this.writeHashBitLen(deType, useHashing);
        ArrayList smsVals = new ArrayList();
        for (SMSDataValue val : values) {
            smsVals.add(val.getSMSValue());
        }
        int fixedIntBitLen = ValueUtil.getBitlenLargestInt(smsVals);
        this.outStream.write(fixedIntBitLen - 1, 4);
        Map<UID, List<SMSDataValue>> valMap = this.groupDataValues(values);
        Iterator<UID> keyIter = valMap.keySet().iterator();
        while (keyIter.hasNext()) {
            UID catOptionCombo = keyIter.next();
            this.writeValID(catOptionCombo, catOptionComboBitLen, useHashing);
            List<SMSDataValue> vals = valMap.get(catOptionCombo);
            Iterator<SMSDataValue> valIter = vals.iterator();
            while (valIter.hasNext()) {
                SMSDataValue val = valIter.next();
                this.writeValID(val.getDataElement(), dataElementBitLen, useHashing);
                ValueUtil.writeSMSValue(val.getSMSValue(), fixedIntBitLen, this.outStream);
                int separator = valIter.hasNext() ? 1 : 0;
                this.outStream.write(separator, 1);
            }
            int separator = keyIter.hasNext() ? 1 : 0;
            this.outStream.write(separator, 1);
        }
    }
}

