/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.ValueWriter;
import org.hisp.dhis.smscompression.models.GeoPoint;
import org.hisp.dhis.smscompression.models.SMSAttributeValue;
import org.hisp.dhis.smscompression.models.SMSDataValue;
import org.hisp.dhis.smscompression.models.SMSEvent;
import org.hisp.dhis.smscompression.models.SMSMetadata;
import org.hisp.dhis.smscompression.models.SMSSubmission;
import org.hisp.dhis.smscompression.models.UID;
import org.hisp.dhis.smscompression.utils.BitOutputStream;
import org.hisp.dhis.smscompression.utils.IDUtil;
import org.hisp.dhis.smscompression.utils.ValueUtil;

public class SMSSubmissionWriter {
    ByteArrayOutputStream byteStream;
    BitOutputStream outStream;
    SMSMetadata meta;
    ValueWriter valueWriter;
    boolean hashingEnabled = true;

    public SMSSubmissionWriter(SMSMetadata meta) throws SMSCompressionException {
        if (meta != null) {
            meta.validate();
        }
        this.meta = meta;
    }

    public boolean isHashingEnabled() {
        return this.hashingEnabled;
    }

    public void setHashingEnabled(boolean useHashing) {
        this.hashingEnabled = useHashing;
    }

    public byte[] compress(SMSSubmission subm) throws SMSCompressionException {
        return this.compress(subm, subm.getCurrentVersion());
    }

    public byte[] compress(SMSSubmission subm, int version) throws SMSCompressionException {
        this.byteStream = new ByteArrayOutputStream();
        this.outStream = new BitOutputStream(this.byteStream);
        this.valueWriter = new ValueWriter(this.outStream, this.meta, this.hashingEnabled);
        subm.write(this.meta, this, version);
        return this.toByteArray();
    }

    public byte[] toByteArray() throws SMSCompressionException {
        try {
            this.outStream.close();
            byte[] subm = this.byteStream.toByteArray();
            byte[] crcSubm = this.writeCRC(subm);
            return crcSubm;
        }
        catch (IOException e) {
            throw new SMSCompressionException(e);
        }
    }

    public byte[] writeCRC(byte[] subm) {
        byte crc;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] calcCRC = digest.digest(subm);
            crc = calcCRC[0];
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        byte[] crcSubm = new byte[subm.length + 1];
        System.arraycopy(subm, 0, crcSubm, 1, subm.length);
        crcSubm[0] = crc;
        return crcSubm;
    }

    public void writeType(SMSConsts.SubmissionType type) throws SMSCompressionException {
        this.outStream.write(type.ordinal(), 4);
    }

    public void writeVersion(int version) throws SMSCompressionException {
        this.outStream.write(version, 4);
    }

    public void writeNonNullableDate(Date date) throws SMSCompressionException {
        ValueUtil.writeDate(date, this.outStream);
    }

    public void writeDate(Date date) throws SMSCompressionException {
        this.writeBool(date != null);
        if (date != null) {
            ValueUtil.writeDate(date, this.outStream);
        }
    }

    public void writeID(UID uid) throws SMSCompressionException {
        IDUtil.writeID(uid, this.hashingEnabled, this.meta, this.outStream);
    }

    public void writeNewID(String id) throws SMSCompressionException {
        IDUtil.writeNewID(id, this.outStream);
    }

    public void writeAttributeValues(List<SMSAttributeValue> values) throws SMSCompressionException {
        this.valueWriter.writeAttributeValues(values);
    }

    public void writeDataValues(List<SMSDataValue> values) throws SMSCompressionException {
        this.valueWriter.writeDataValues(values);
    }

    public void writeBool(boolean val) throws SMSCompressionException {
        ValueUtil.writeBool(val, this.outStream);
    }

    public void writePeriod(String period) throws SMSCompressionException {
        ValueUtil.writeString(period, this.outStream);
    }

    public void writeSubmissionID(int submissionID) throws SMSCompressionException {
        this.outStream.write(submissionID, 8);
    }

    public void writeEventStatus(SMSConsts.SMSEventStatus eventStatus) throws SMSCompressionException {
        this.outStream.write(eventStatus.ordinal(), 3);
    }

    public void writeEvents(List<SMSEvent> events, int version) throws SMSCompressionException {
        boolean hasEvents = events != null && !events.isEmpty();
        this.writeBool(hasEvents);
        if (hasEvents) {
            Iterator<SMSEvent> eventIter = events.iterator();
            while (eventIter.hasNext()) {
                SMSEvent event = eventIter.next();
                event.writeEvent(this, version);
                this.writeBool(eventIter.hasNext());
            }
        }
    }

    public void writeGeoPoint(GeoPoint coordinates) throws SMSCompressionException {
        this.writeBool(coordinates != null);
        if (coordinates != null) {
            ValueUtil.writeFloat(coordinates.getLatitude(), this.outStream);
            ValueUtil.writeFloat(coordinates.getLongitude(), this.outStream);
        }
    }

    public void writeEnrollmentStatus(SMSConsts.SMSEnrollmentStatus enrollmentStatus) throws SMSCompressionException {
        this.outStream.write(enrollmentStatus.ordinal(), 2);
    }
}

