/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.smscompression;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.hisp.dhis.smscompression.SMSCompressionException;
import org.hisp.dhis.smscompression.SMSConsts;
import org.hisp.dhis.smscompression.ValueReader;
import org.hisp.dhis.smscompression.models.AggregateDatasetSMSSubmission;
import org.hisp.dhis.smscompression.models.DeleteSMSSubmission;
import org.hisp.dhis.smscompression.models.EnrollmentSMSSubmission;
import org.hisp.dhis.smscompression.models.GeoPoint;
import org.hisp.dhis.smscompression.models.RelationshipSMSSubmission;
import org.hisp.dhis.smscompression.models.SMSAttributeValue;
import org.hisp.dhis.smscompression.models.SMSDataValue;
import org.hisp.dhis.smscompression.models.SMSEvent;
import org.hisp.dhis.smscompression.models.SMSMetadata;
import org.hisp.dhis.smscompression.models.SMSSubmission;
import org.hisp.dhis.smscompression.models.SMSSubmissionHeader;
import org.hisp.dhis.smscompression.models.SimpleEventSMSSubmission;
import org.hisp.dhis.smscompression.models.TrackerEventSMSSubmission;
import org.hisp.dhis.smscompression.models.UID;
import org.hisp.dhis.smscompression.utils.BitInputStream;
import org.hisp.dhis.smscompression.utils.IDUtil;
import org.hisp.dhis.smscompression.utils.ValueUtil;

public class SMSSubmissionReader {
    BitInputStream inStream;
    SMSMetadata meta;
    ValueReader valueReader;

    public SMSSubmissionHeader readHeader(byte[] smsBytes) throws SMSCompressionException {
        if (!this.checkCRC(smsBytes)) {
            throw new SMSCompressionException("Invalid CRC - CRC in header does not match submission");
        }
        ByteArrayInputStream byteStream = new ByteArrayInputStream(smsBytes);
        this.inStream = new BitInputStream(byteStream);
        this.inStream.read(8);
        SMSSubmissionHeader header = new SMSSubmissionHeader();
        header.readHeader(this);
        return header;
    }

    public SMSSubmission readSubmission(byte[] smsBytes, SMSMetadata meta) throws SMSCompressionException {
        if (meta != null) {
            meta.validate();
        }
        this.meta = meta;
        SMSSubmissionHeader header = this.readHeader(smsBytes);
        this.valueReader = new ValueReader(this.inStream, meta);
        SMSSubmission subm = null;
        switch (header.getType()) {
            case AGGREGATE_DATASET: {
                subm = new AggregateDatasetSMSSubmission();
                break;
            }
            case DELETE: {
                subm = new DeleteSMSSubmission();
                break;
            }
            case ENROLLMENT: {
                subm = new EnrollmentSMSSubmission();
                break;
            }
            case RELATIONSHIP: {
                subm = new RelationshipSMSSubmission();
                break;
            }
            case SIMPLE_EVENT: {
                subm = new SimpleEventSMSSubmission();
                break;
            }
            case TRACKER_EVENT: {
                subm = new TrackerEventSMSSubmission();
                break;
            }
            default: {
                throw new SMSCompressionException("Unknown SMS Submission Type: " + (Object)((Object)header.getType()));
            }
        }
        subm.read(this, header);
        try {
            this.inStream.close();
        }
        catch (IOException e) {
            throw new SMSCompressionException(e);
        }
        return subm;
    }

    private boolean checkCRC(byte[] smsBytes) {
        byte crc = smsBytes[0];
        byte[] submBytes = Arrays.copyOfRange(smsBytes, 1, smsBytes.length);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] calcCRC = digest.digest(submBytes);
            return calcCRC[0] == crc;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return false;
        }
    }

    public SMSConsts.SubmissionType readType() throws SMSCompressionException {
        int submType = this.inStream.read(4);
        return SMSConsts.SubmissionType.values()[submType];
    }

    public int readVersion() throws SMSCompressionException {
        return this.inStream.read(4);
    }

    public Date readNonNullableDate() throws SMSCompressionException {
        return ValueUtil.readDate(this.inStream);
    }

    public Date readDate() throws SMSCompressionException {
        boolean hasDate = this.readBool();
        if (!hasDate) {
            return null;
        }
        return ValueUtil.readDate(this.inStream);
    }

    public UID readID(SMSConsts.MetadataType type) throws SMSCompressionException {
        return IDUtil.readID(type, this.meta, this.inStream);
    }

    public String readNewID() throws SMSCompressionException {
        return IDUtil.readNewID(this.inStream);
    }

    public List<SMSAttributeValue> readAttributeValues() throws SMSCompressionException {
        return this.valueReader.readAttributeValues();
    }

    public List<SMSDataValue> readDataValues() throws SMSCompressionException {
        return this.valueReader.readDataValues();
    }

    public boolean readBool() throws SMSCompressionException {
        return ValueUtil.readBool(this.inStream);
    }

    public String readPeriod() throws SMSCompressionException {
        return ValueUtil.readString(this.inStream);
    }

    public int readSubmissionID() throws SMSCompressionException {
        return this.inStream.read(8);
    }

    public SMSConsts.SMSEventStatus readEventStatus() throws SMSCompressionException {
        int eventStatusNum = this.inStream.read(3);
        return SMSConsts.SMSEventStatus.values()[eventStatusNum];
    }

    public List<SMSEvent> readEvents(int version) throws SMSCompressionException {
        boolean hasEvents = this.readBool();
        ArrayList<SMSEvent> events = null;
        if (hasEvents) {
            events = new ArrayList<SMSEvent>();
            boolean hasNext = true;
            while (hasNext) {
                SMSEvent event = new SMSEvent();
                event.readEvent(this, version);
                events.add(event);
                hasNext = this.readBool();
            }
        }
        return events;
    }

    public GeoPoint readGeoPoint() throws SMSCompressionException {
        GeoPoint gp = null;
        boolean hasGeoPoint = this.readBool();
        if (hasGeoPoint) {
            float lat = ValueUtil.readFloat(this.inStream);
            float lon = ValueUtil.readFloat(this.inStream);
            gp = new GeoPoint(lat, lon);
        }
        return gp;
    }

    public SMSConsts.SMSEnrollmentStatus readEnrollmentStatus() throws SMSCompressionException {
        int enrollStatusNum = this.inStream.read(2);
        return SMSConsts.SMSEnrollmentStatus.values()[enrollStatusNum];
    }
}

