/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhiraj072.randomwordgenerator.datamuse;

import com.github.dhiraj072.randomwordgenerator.datamuse.WordsRequest;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Dsl;

public class DataMuseRequest
implements WordsRequest {
    private static final String DATAMUSE_API_URL = "https://api.datamuse.com/words";
    private BoundRequestBuilder request = Dsl.asyncHttpClient().prepareGet("https://api.datamuse.com/words");

    public DataMuseRequest() {
        this.maxResults(500);
    }

    public DataMuseRequest topics(String ... topics) {
        StringBuilder topicsParam = new StringBuilder();
        int count = 0;
        for (String topic : topics) {
            topicsParam.append(topic);
            if (++count == 5) break;
            topicsParam.append(",");
        }
        this.request.addQueryParam("topics", topicsParam.toString());
        return this;
    }

    protected DataMuseRequest maxResults(int maxResults) {
        this.request.addQueryParam("max", Integer.toString(Math.min(maxResults, 1000)));
        return this;
    }

    @Override
    public BoundRequestBuilder build() {
        return this.request;
    }
}

