/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhiraj072.randomwordgenerator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dhiraj072.randomwordgenerator.Topics;
import com.github.dhiraj072.randomwordgenerator.datamuse.DataMuseRequest;
import com.github.dhiraj072.randomwordgenerator.datamuse.DataMuseWord;
import com.github.dhiraj072.randomwordgenerator.datamuse.WordsRequest;
import com.github.dhiraj072.randomwordgenerator.exceptions.DataMuseException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomWordGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomWordGenerator.class);
    private static List<DataMuseWord> randomWords;
    private static final ObjectMapper MAPPER;
    private static Random random;

    private RandomWordGenerator() {
    }

    private static void initializeNewRandomWords() {
        LOGGER.debug("Initializing with new random word");
        try {
            DataMuseRequest standardRequest = new DataMuseRequest().topics(Topics.getRandomTopic());
            RandomWordGenerator.setRandomWords(RandomWordGenerator.getDataMuseWords(standardRequest));
        }
        catch (DataMuseException e) {
            LOGGER.error("Error getting word from DataMuse, setting a random word locally", (Throwable)e);
            RandomWordGenerator.setRandomWordLocally();
        }
    }

    private static List<DataMuseWord> getDataMuseWords(WordsRequest request) throws DataMuseException {
        try {
            Response response = (Response)request.build().execute().get();
            LOGGER.debug("Got list of words {}", (Object)response.getResponseBody());
            List words = (List)MAPPER.readValue(response.getResponseBody(), (TypeReference)new TypeReference<List<DataMuseWord>>(){});
            if (words.isEmpty()) {
                throw new DataMuseException("DataMuse API did not return any words for request " + request.toString());
            }
            return words;
        }
        catch (IOException | ExecutionException e) {
            throw new DataMuseException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalThreadStateException("Thread interrupted: " + e.toString());
        }
    }

    public static String getRandomWord() {
        new Thread(RandomWordGenerator::initializeNewRandomWords).start();
        return randomWords.get(random.nextInt(randomWords.size())).getWord();
    }

    public static String getRandomWord(WordsRequest request) throws DataMuseException {
        List<DataMuseWord> wordsReturned = RandomWordGenerator.getDataMuseWords(request);
        return wordsReturned.get(random.nextInt(wordsReturned.size())).getWord();
    }

    private static void setRandomWordLocally() {
        randomWords = Collections.singletonList(new DataMuseWord(Topics.getRandomTopic()));
    }

    private static void setRandomWords(List<DataMuseWord> words) {
        randomWords = words;
    }

    static {
        MAPPER = new ObjectMapper();
        random = new Random();
        RandomWordGenerator.initializeNewRandomWords();
    }
}

