/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import androidx.documentfile.provider.DocumentFile;
import com.github.dhaval2404.imagepicker.R;
import com.github.dhaval2404.imagepicker.util.FileUriUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001b\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\rJ#\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u0010\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001f\u0010\u0016\u001a\u00020\u0004*\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/github/dhaval2404/imagepicker/util/IntentUtils;", "", "()V", "getCameraIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "file", "Ljava/io/File;", "getGalleryDocumentIntent", "mimeTypes", "", "", "([Ljava/lang/String;)Landroid/content/Intent;", "getGalleryIntent", "(Landroid/content/Context;[Ljava/lang/String;)Landroid/content/Intent;", "getLegacyGalleryPickIntent", "getUriViewIntent", "uri", "Landroid/net/Uri;", "isCameraAppAvailable", "", "applyImageTypes", "(Landroid/content/Intent;[Ljava/lang/String;)Landroid/content/Intent;", "imagepicker_release"})
public final class IntentUtils {
    public static final IntentUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final Intent getGalleryIntent(@NotNull Context context, @NotNull String[] mimeTypes) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        if (Build.VERSION.SDK_INT >= 19 && (intent = INSTANCE.getGalleryDocumentIntent(mimeTypes)).resolveActivity(context.getPackageManager()) != null) {
            return intent;
        }
        return INSTANCE.getLegacyGalleryPickIntent(mimeTypes);
    }

    private final Intent getGalleryDocumentIntent(String[] mimeTypes) {
        Intent intent = this.applyImageTypes(new Intent("android.intent.action.OPEN_DOCUMENT"), mimeTypes);
        intent.addCategory("android.intent.category.OPENABLE");
        intent.addFlags(64);
        intent.addFlags(1);
        intent.addFlags(2);
        return intent;
    }

    private final Intent getLegacyGalleryPickIntent(String[] mimeTypes) {
        return this.applyImageTypes(new Intent("android.intent.action.PICK"), mimeTypes);
    }

    private final Intent applyImageTypes(Intent $this$applyImageTypes, String[] mimeTypes) {
        $this$applyImageTypes.setType("image/*");
        String[] stringArray = mimeTypes;
        boolean bl = false;
        String[] stringArray2 = stringArray;
        boolean bl2 = false;
        if (!(stringArray2.length == 0)) {
            $this$applyImageTypes.putExtra("android.intent.extra.MIME_TYPES", mimeTypes);
        }
        return $this$applyImageTypes;
    }

    @JvmStatic
    @Nullable
    public static final Intent getCameraIntent(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (Build.VERSION.SDK_INT >= 24) {
            String authority = context.getPackageName() + context.getString(R.string.image_picker_provider_authority_suffix);
            Uri photoURI = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
            intent.putExtra("output", (Parcelable)photoURI);
        } else {
            intent.putExtra("output", (Parcelable)Uri.fromFile((File)file));
        }
        return intent;
    }

    @JvmStatic
    public static final boolean isCameraAppAvailable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        return intent.resolveActivity(context.getPackageManager()) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmStatic
    @NotNull
    public static final Intent getUriViewIntent(@NotNull Context context, @NotNull Uri uri) {
        Uri uri2;
        DocumentFile file;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intent intent = new Intent("android.intent.action.VIEW");
        String authority = context.getPackageName() + context.getString(R.string.image_picker_provider_authority_suffix);
        DocumentFile documentFile = file = DocumentFile.fromSingleUri((Context)context, (Uri)uri);
        if (documentFile != null && documentFile.canRead()) {
            uri2 = uri;
        } else {
            String string2 = FileUriUtils.INSTANCE.getRealPath(context, uri);
            Intrinsics.checkNotNull((Object)string2);
            String filePath = string2;
            uri2 = FileProvider.getUriForFile((Context)context, (String)authority, (File)new File(filePath));
        }
        Uri dataUri = uri2;
        intent.setDataAndType(dataUri, "image/*");
        intent.addFlags(1);
        return intent;
    }

    private IntentUtils() {
    }

    static {
        IntentUtils intentUtils;
        INSTANCE = intentUtils = new IntentUtils();
    }
}

