/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.os.StatFs;
import androidx.documentfile.provider.DocumentFile;
import com.github.dhaval2404.imagepicker.util.FileUriUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u0006H\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00112\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\"\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u001b\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/github/dhaval2404/imagepicker/util/FileUtil;", "", "()V", "getCompressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "extension", "", "getDocumentFile", "Landroidx/documentfile/provider/DocumentFile;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "getFileName", "getFreeSpace", "", "file", "Ljava/io/File;", "getImageExtension", "uriImage", "getImageFile", "fileDir", "getImageResolution", "Lkotlin/Pair;", "", "getImageSize", "getTempFile", "getTimestamp", "isFileUri", "", "imagepicker_release"})
public final class FileUtil {
    public static final FileUtil INSTANCE;

    @Nullable
    public final File getImageFile(@NotNull File fileDir, @Nullable String extension) {
        Intrinsics.checkNotNullParameter((Object)fileDir, (String)"fileDir");
        try {
            String string2 = extension;
            if (string2 == null) {
                string2 = ".jpg";
            }
            String ext = string2;
            String fileName = this.getFileName();
            String imageFileName = fileName + ext;
            if (!fileDir.exists()) {
                fileDir.mkdirs();
            }
            File file = new File(fileDir, imageFileName);
            file.createNewFile();
            return file;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static /* synthetic */ File getImageFile$default(FileUtil fileUtil, File file, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return fileUtil.getImageFile(file, string2);
    }

    private final String getFileName() {
        return "IMG_" + this.getTimestamp();
    }

    private final String getTimestamp() {
        String timeFormat = "yyyyMMdd_HHmmssSSS";
        String string2 = new SimpleDateFormat(timeFormat, Locale.getDefault()).format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SimpleDateFormat(timeFor\u2026Default()).format(Date())");
        return string2;
    }

    public final long getFreeSpace(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        StatFs stat = new StatFs(file.getPath());
        long availBlocks = stat.getAvailableBlocksLong();
        long blockSize = stat.getBlockSizeLong();
        return availBlocks * blockSize;
    }

    @NotNull
    public final Pair<Integer, Integer> getImageResolution(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        InputStream stream = context.getContentResolver().openInputStream(uri);
        BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
        return new Pair((Object)options.outWidth, (Object)options.outHeight);
    }

    @NotNull
    public final Pair<Integer, Integer> getImageResolution(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
        return new Pair((Object)options.outWidth, (Object)options.outHeight);
    }

    public final long getImageSize(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        DocumentFile documentFile = this.getDocumentFile(context, uri);
        return documentFile != null ? documentFile.length() : 0L;
    }

    @Nullable
    public final File getTempFile(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            File destination = new File(context.getCacheDir(), "image_picker.png");
            ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
            Object object = parcelFileDescriptor;
            if (object == null || (object = object.getFileDescriptor()) == null) {
                return null;
            }
            Object fileDescriptor = object;
            FileChannel src = new FileInputStream((FileDescriptor)fileDescriptor).getChannel();
            FileChannel dst = new FileOutputStream(destination).getChannel();
            dst.transferFrom(src, 0L, src.size());
            src.close();
            dst.close();
            return destination;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Nullable
    public final DocumentFile getDocumentFile(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        DocumentFile file = null;
        if (this.isFileUri(uri)) {
            String path = FileUriUtils.INSTANCE.getRealPath(context, uri);
            if (path != null) {
                file = DocumentFile.fromFile((File)new File(path));
            }
        } else {
            file = DocumentFile.fromSingleUri((Context)context, (Uri)uri);
        }
        return file;
    }

    @NotNull
    public final Bitmap.CompressFormat getCompressFormat(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return StringsKt.contains((CharSequence)extension, (CharSequence)"png", (boolean)true) ? Bitmap.CompressFormat.PNG : (StringsKt.contains((CharSequence)extension, (CharSequence)"webp", (boolean)true) ? (Build.VERSION.SDK_INT >= 30 ? Bitmap.CompressFormat.WEBP_LOSSLESS : Bitmap.CompressFormat.WEBP) : Bitmap.CompressFormat.JPEG);
    }

    @NotNull
    public final String getImageExtension(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Uri uri = Uri.fromFile((File)file);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Uri.fromFile(file)");
        return this.getImageExtension(uri);
    }

    @NotNull
    public final String getImageExtension(@NotNull Uri uriImage) {
        String extension;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)uriImage, (String)"uriImage");
                extension = null;
                try {
                    String imagePath = uriImage.getPath();
                    if (imagePath != null && StringsKt.lastIndexOf$default((CharSequence)imagePath, (String)".", (int)0, (boolean)false, (int)6, null) != -1) {
                        String string2 = imagePath;
                        int n = StringsKt.lastIndexOf$default((CharSequence)imagePath, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
                        boolean bl = false;
                        String string3 = string2.substring(n);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                        extension = string3;
                    }
                }
                catch (Exception e) {
                    extension = null;
                }
                if (extension == null) break block7;
                CharSequence charSequence = extension;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block8;
            }
            extension = "jpg";
        }
        return '.' + extension;
    }

    private final boolean isFileUri(Uri uri) {
        return StringsKt.equals((String)"file", (String)uri.getScheme(), (boolean)true);
    }

    private FileUtil() {
    }

    static {
        FileUtil fileUtil;
        INSTANCE = fileUtil = new FileUtil();
    }
}

