/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.util;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import com.github.dhaval2404.imagepicker.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/github/dhaval2404/imagepicker/util/FileUriUtils;", "", "()V", "getDataColumn", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getDownloadDocument", "getFilePath", "getMediaDocument", "getPathFromLocalUri", "getPathFromRemoteUri", "getRealPath", "isDownloadsDocument", "", "isExternalStorageDocument", "isGooglePhotosUri", "isMediaDocument", "imagepicker_release"})
public final class FileUriUtils {
    public static final FileUriUtils INSTANCE;

    @Nullable
    public final String getRealPath(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String path = this.getPathFromLocalUri(context, uri);
        if (path == null) {
            path = this.getPathFromRemoteUri(context, uri);
        }
        return path;
    }

    private final String getPathFromLocalUri(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (this.isExternalStorageDocument(uri)) {
                String path;
                List list;
                String docId;
                String string2 = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"docId");
                CharSequence charSequence = string2;
                String string3 = ":";
                int n = 0;
                string3 = new Regex(string3);
                n = 0;
                boolean bl2 = false;
                List $this$dropLastWhile$iv = string3.split(charSequence, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl3 = false;
                        CharSequence charSequence2 = it;
                        boolean bl4 = false;
                        if (charSequence2.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                String string4 = StringsKt.equals((String)"primary", (String)type, (boolean)true) ? (split.length > 1 ? Environment.getExternalStorageDirectory().toString() + "/" + split[1] : Environment.getExternalStorageDirectory().toString() + "/") : (new File(path = "storage/" + StringsKt.replace$default((String)docId, (String)":", (String)"/", (boolean)false, (int)4, null)).exists() ? path : "/storage/sdcard/" + split[1]);
                return string4;
            }
            if (this.isDownloadsDocument(uri)) {
                return this.getDownloadDocument(context, uri);
            }
            if (this.isMediaDocument(uri)) {
                return this.getMediaDocument(context, uri);
            }
        } else {
            String string5 = uri.getScheme();
            Intrinsics.checkNotNull((Object)string5);
            if (StringsKt.equals((String)"content", (String)string5, (boolean)true)) {
                return this.isGooglePhotosUri(uri) ? uri.getLastPathSegment() : this.getDataColumn(context, uri, null, null);
            }
            String string6 = uri.getScheme();
            Intrinsics.checkNotNull((Object)string6);
            if (StringsKt.equals((String)"file", (String)string6, (boolean)true)) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        block8: {
            Cursor cursor;
            Cursor cursor2 = null;
            String column = "_data";
            String[] projection = new String[]{column};
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri2 = uri;
                Intrinsics.checkNotNull((Object)uri2);
                cursor2 = contentResolver.query(uri2, projection, selection, selectionArgs, null);
                if (cursor2 != null && cursor2.moveToFirst()) {
                    int index = cursor2.getColumnIndexOrThrow(column);
                    String string2 = cursor2.getString(index);
                    cursor2.close();
                    return string2;
                }
                cursor = cursor2;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                break block8;
            }
            finally {
                Cursor cursor3 = cursor2;
                if (cursor3 != null) {
                    cursor3.close();
                }
            }
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    private final String getDownloadDocument(Context context, Uri uri) {
        String id2;
        String path;
        String fileName = this.getFilePath(context, uri);
        if (fileName != null && new File(path = Environment.getExternalStorageDirectory().toString() + "/Download/" + fileName).exists()) {
            return path;
        }
        String string2 = id2 = DocumentsContract.getDocumentId((Uri)uri);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id");
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)":", (boolean)false, (int)2, null)) {
            id2 = (String)StringsKt.split$default((CharSequence)id2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(1);
        }
        Uri uri2 = Uri.parse((String)"content://downloads/public_downloads");
        Long l = Long.valueOf(id2);
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"java.lang.Long.valueOf(id)");
        Uri uri3 = ContentUris.withAppendedId((Uri)uri2, (long)l);
        Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"ContentUris.withAppended\u2026ong.valueOf(id)\n        )");
        Uri contentUri = uri3;
        return this.getDataColumn(context, contentUri, null, null);
    }

    private final String getMediaDocument(Context context, Uri uri) {
        List list;
        String docId;
        String string2 = docId = DocumentsContract.getDocumentId((Uri)uri);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"docId");
        CharSequence charSequence = string2;
        String string3 = ":";
        int n = 0;
        string3 = new Regex(string3);
        n = 0;
        boolean bl = false;
        List $this$dropLastWhile$iv = string3.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                CharSequence charSequence2 = it;
                boolean bl3 = false;
                if (charSequence2.length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] split = stringArray;
        String type = split[0];
        Uri contentUri = null;
        if (Intrinsics.areEqual((Object)"image", (Object)type)) {
            contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        } else if (Intrinsics.areEqual((Object)"video", (Object)type)) {
            contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        } else if (Intrinsics.areEqual((Object)"audio", (Object)type)) {
            contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        }
        String selection = "_id=?";
        String[] selectionArgs = new String[]{split[1]};
        return this.getDataColumn(context, contentUri, selection, selectionArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFilePath(Context context, Uri uri) {
        Cursor cursor;
        block4: {
            String string2;
            cursor = null;
            String[] projection = new String[]{"_display_name"};
            try {
                cursor = context.getContentResolver().query(uri, projection, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                int index = cursor.getColumnIndexOrThrow("_display_name");
                string2 = cursor.getString(index);
            }
            catch (Throwable throwable) {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                throw throwable;
            }
            cursor.close();
            return string2;
        }
        Cursor cursor3 = cursor;
        if (cursor3 != null) {
            cursor3.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final String getPathFromRemoteUri(Context context, Uri uri) {
        String string2;
        boolean success;
        File file;
        block31: {
            OutputStream outputStream;
            InputStream inputStream;
            block30: {
                block29: {
                    file = null;
                    inputStream = null;
                    outputStream = null;
                    success = false;
                    String extension = FileUtil.INSTANCE.getImageExtension(uri);
                    inputStream = context.getContentResolver().openInputStream(uri);
                    File file2 = context.getCacheDir();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"context.cacheDir");
                    file = FileUtil.INSTANCE.getImageFile(file2, extension);
                    if (file != null) break block29;
                    String string3 = null;
                    try {
                        InputStream inputStream2 = inputStream;
                        if (inputStream2 != null) {
                            inputStream2.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                    }
                    catch (IOException ignored) {
                        success = false;
                    }
                    return string3;
                }
                outputStream = new FileOutputStream(file);
                if (inputStream == null) break block30;
                ByteStreamsKt.copyTo((InputStream)inputStream, (OutputStream)outputStream, (int)4096);
                success = true;
            }
            try {
                InputStream inputStream3 = inputStream;
                if (inputStream3 != null) {
                    inputStream3.close();
                }
            }
            catch (IOException extension) {
                // empty catch block
            }
            try {
                outputStream.close();
            }
            catch (IOException ignored2222222222) {
                success = false;
            }
            break block31;
            catch (IOException ignored2222222222) {
                try {
                    InputStream inputStream4 = inputStream;
                    if (inputStream4 != null) {
                        inputStream4.close();
                    }
                }
                catch (IOException ignored2222222222) {
                    // empty catch block
                }
                try {
                    OutputStream outputStream2 = outputStream;
                    if (outputStream2 != null) {
                        outputStream2.close();
                    }
                    break block31;
                }
                catch (IOException ignored3) {
                    success = false;
                }
                break block31;
                catch (Throwable throwable) {
                    try {
                        InputStream inputStream5 = inputStream;
                        if (inputStream5 != null) {
                            inputStream5.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        OutputStream outputStream3 = outputStream;
                        if (outputStream3 != null) {
                            outputStream3.close();
                        }
                    }
                    catch (IOException ignored4) {
                        success = false;
                    }
                    throw throwable;
                }
            }
        }
        if (success) {
            File file3 = file;
            Intrinsics.checkNotNull((Object)file3);
            string2 = file3.getPath();
        } else {
            string2 = null;
        }
        return string2;
    }

    private final boolean isExternalStorageDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    private final boolean isDownloadsDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    private final boolean isMediaDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    private final boolean isGooglePhotosUri(Uri uri) {
        return Intrinsics.areEqual((Object)"com.google.android.apps.photos.content", (Object)uri.getAuthority());
    }

    private FileUriUtils() {
    }

    static {
        FileUriUtils fileUriUtils;
        INSTANCE = fileUriUtils = new FileUriUtils();
    }
}

