/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.util;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import com.github.dhaval2404.imagepicker.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/github/dhaval2404/imagepicker/util/FileUriUtils;", "", "()V", "getDataColumn", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getFilePath", "getImageExtension", "uriImage", "file", "Ljava/io/File;", "getPathFromLocalUri", "getPathFromRemoteUri", "getRealPath", "isDownloadsDocument", "", "isExternalStorageDocument", "isGooglePhotosUri", "isMediaDocument", "imagepicker_release"})
public final class FileUriUtils {
    public static final FileUriUtils INSTANCE;

    @Nullable
    public final String getRealPath(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        String path = this.getPathFromLocalUri(context, uri);
        if (path == null) {
            path = this.getPathFromRemoteUri(context, uri);
        }
        return path;
    }

    private final String getPathFromLocalUri(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (this.isExternalStorageDocument(uri)) {
                String path;
                List list;
                String docId;
                String string2 = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"docId");
                CharSequence charSequence = string2;
                String string3 = ":";
                int n = 0;
                string3 = new Regex(string3);
                n = 0;
                boolean bl2 = false;
                List $this$dropLastWhile$iv = string3.split(charSequence, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl3 = false;
                        CharSequence charSequence2 = it;
                        boolean bl4 = false;
                        if (charSequence2.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                String string4 = StringsKt.equals((String)"primary", (String)type, (boolean)true) ? (split.length > 1 ? Environment.getExternalStorageDirectory().toString() + "/" + split[1] : Environment.getExternalStorageDirectory().toString() + "/") : (new File(path = "storage/" + StringsKt.replace$default((String)docId, (String)":", (String)"/", (boolean)false, (int)4, null)).exists() ? path : "/storage/sdcard/" + split[1]);
                return string4;
            }
            if (this.isDownloadsDocument(uri)) {
                String id2;
                String path;
                String fileName = this.getFilePath(context, uri);
                if (fileName != null && new File(path = Environment.getExternalStorageDirectory().toString() + "/Download/" + fileName).exists()) {
                    return path;
                }
                String string5 = id2 = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"id");
                if (StringsKt.contains$default((CharSequence)string5, (CharSequence)":", (boolean)false, (int)2, null)) {
                    id2 = (String)StringsKt.split$default((CharSequence)id2, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null).get(1);
                }
                Uri uri2 = Uri.parse((String)"content://downloads/public_downloads");
                Long l = Long.valueOf(id2);
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"java.lang.Long.valueOf(id)");
                Uri contentUri = ContentUris.withAppendedId((Uri)uri2, (long)l);
                return this.getDataColumn(context, contentUri, null, null);
            }
            if (this.isMediaDocument(uri)) {
                List list;
                String docId;
                String string6 = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"docId");
                CharSequence contentUri = string6;
                String path = ":";
                int thisCollection$iv = 0;
                path = new Regex(path);
                thisCollection$iv = 0;
                boolean it = false;
                List $this$dropLastWhile$iv = path.split(contentUri, thisCollection$iv);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it2 = (String)iterator$iv.previous();
                        boolean bl5 = false;
                        CharSequence charSequence = it2;
                        boolean bl6 = false;
                        if (charSequence.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv2 = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv2.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                Uri contentUri2 = null;
                if (Intrinsics.areEqual((Object)"image", (Object)type)) {
                    contentUri2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if (Intrinsics.areEqual((Object)"video", (Object)type)) {
                    contentUri2 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if (Intrinsics.areEqual((Object)"audio", (Object)type)) {
                    contentUri2 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                return this.getDataColumn(context, contentUri2, selection, selectionArgs);
            }
        } else {
            String string7 = uri.getScheme();
            if (string7 == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.equals((String)"content", (String)string7, (boolean)true)) {
                return this.isGooglePhotosUri(uri) ? uri.getLastPathSegment() : this.getDataColumn(context, uri, null, null);
            }
            String string8 = uri.getScheme();
            if (string8 == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.equals((String)"file", (String)string8, (boolean)true)) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor;
        block8: {
            String string2;
            cursor = null;
            String column = "_data";
            String[] projection = new String[]{column};
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri2 = uri;
                if (uri2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((cursor = contentResolver.query(uri2, projection, selection, selectionArgs, null)) == null || !cursor.moveToFirst()) break block8;
                int index = cursor.getColumnIndexOrThrow(column);
                string2 = cursor.getString(index);
            }
            catch (Exception exception) {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                catch (Throwable throwable) {
                    Cursor cursor3 = cursor;
                    if (cursor3 != null) {
                        cursor3.close();
                    }
                    throw throwable;
                }
            }
            cursor.close();
            return string2;
        }
        Cursor cursor4 = cursor;
        if (cursor4 != null) {
            cursor4.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFilePath(Context context, Uri uri) {
        Cursor cursor;
        block4: {
            String string2;
            cursor = null;
            String[] projection = new String[]{"_display_name"};
            try {
                cursor = context.getContentResolver().query(uri, projection, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                int index = cursor.getColumnIndexOrThrow("_display_name");
                string2 = cursor.getString(index);
            }
            catch (Throwable throwable) {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                throw throwable;
            }
            cursor.close();
            return string2;
        }
        Cursor cursor3 = cursor;
        if (cursor3 != null) {
            cursor3.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final String getPathFromRemoteUri(Context context, Uri uri) {
        String string2;
        boolean success;
        File file;
        block32: {
            OutputStream outputStream;
            InputStream inputStream;
            block31: {
                block30: {
                    file = null;
                    inputStream = null;
                    outputStream = null;
                    success = false;
                    String extension = this.getImageExtension(uri);
                    inputStream = context.getContentResolver().openInputStream(uri);
                    file = FileUtil.INSTANCE.getImageFile(context.getCacheDir(), extension);
                    if (file != null) break block30;
                    String string3 = null;
                    try {
                        InputStream inputStream2 = inputStream;
                        if (inputStream2 != null) {
                            inputStream2.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                    }
                    catch (IOException ignored) {
                        success = false;
                    }
                    return string3;
                }
                outputStream = new FileOutputStream(file);
                if (inputStream == null) break block31;
                ByteStreamsKt.copyTo((InputStream)inputStream, (OutputStream)outputStream, (int)4096);
                success = true;
            }
            try {
                InputStream inputStream3 = inputStream;
                if (inputStream3 != null) {
                    inputStream3.close();
                }
            }
            catch (IOException extension) {
                // empty catch block
            }
            try {
                outputStream.close();
            }
            catch (IOException ignored2222222222) {
                success = false;
            }
            break block32;
            catch (IOException ignored2222222222) {
                try {
                    InputStream inputStream4 = inputStream;
                    if (inputStream4 != null) {
                        inputStream4.close();
                    }
                }
                catch (IOException ignored2222222222) {
                    // empty catch block
                }
                try {
                    OutputStream outputStream2 = outputStream;
                    if (outputStream2 != null) {
                        outputStream2.close();
                    }
                    break block32;
                }
                catch (IOException ignored3) {
                    success = false;
                }
                break block32;
                catch (Throwable throwable) {
                    try {
                        InputStream inputStream5 = inputStream;
                        if (inputStream5 != null) {
                            inputStream5.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        OutputStream outputStream3 = outputStream;
                        if (outputStream3 != null) {
                            outputStream3.close();
                        }
                    }
                    catch (IOException ignored4) {
                        success = false;
                    }
                    throw throwable;
                }
            }
        }
        if (success) {
            File file2 = file;
            if (file2 == null) {
                Intrinsics.throwNpe();
            }
            string2 = file2.getPath();
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public final String getImageExtension(@NotNull Uri uriImage) {
        String extension;
        block8: {
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)uriImage, (String)"uriImage");
                extension = null;
                try {
                    String imagePath = uriImage.getPath();
                    if (imagePath != null && StringsKt.lastIndexOf$default((CharSequence)imagePath, (String)".", (int)0, (boolean)false, (int)6, null) != -1) {
                        String string2 = imagePath;
                        int n = StringsKt.lastIndexOf$default((CharSequence)imagePath, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
                        boolean bl = false;
                        String string3 = string2.substring(n);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                        extension = string3;
                    }
                }
                catch (Exception e) {
                    extension = null;
                }
                if (extension == null) break block7;
                CharSequence charSequence = extension;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block8;
            }
            extension = "jpg";
        }
        return '.' + extension;
    }

    @NotNull
    public final String getImageExtension(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Uri uri = Uri.fromFile((File)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.fromFile(file)");
        return this.getImageExtension(uri);
    }

    private final boolean isExternalStorageDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    private final boolean isDownloadsDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    private final boolean isMediaDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    private final boolean isGooglePhotosUri(Uri uri) {
        return Intrinsics.areEqual((Object)"com.google.android.apps.photos.content", (Object)uri.getAuthority());
    }

    private FileUriUtils() {
    }

    static {
        FileUriUtils fileUriUtils;
        INSTANCE = fileUriUtils = new FileUriUtils();
    }
}

