/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.fragment.app.FragmentActivity;
import com.github.dhaval2404.imagepicker.ImagePickerActivity$WhenMappings;
import com.github.dhaval2404.imagepicker.R;
import com.github.dhaval2404.imagepicker.constant.ImageProvider;
import com.github.dhaval2404.imagepicker.provider.CameraProvider;
import com.github.dhaval2404.imagepicker.provider.CompressionProvider;
import com.github.dhaval2404.imagepicker.provider.CropProvider;
import com.github.dhaval2404.imagepicker.provider.GalleryProvider;
import java.io.File;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u000b\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0012\u0010\u0017\u001a\u00020\u000f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J+\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\bJ\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\bJ\u000e\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u001dJ\u000e\u0010&\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\bJ\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\bH\u0002J\u0006\u0010(\u001a\u00020\u000fR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;", "Landroidx/fragment/app/FragmentActivity;", "()V", "mCameraProvider", "Lcom/github/dhaval2404/imagepicker/provider/CameraProvider;", "mCompressionProvider", "Lcom/github/dhaval2404/imagepicker/provider/CompressionProvider;", "mCropFile", "Ljava/io/File;", "mCropProvider", "Lcom/github/dhaval2404/imagepicker/provider/CropProvider;", "mGalleryProvider", "Lcom/github/dhaval2404/imagepicker/provider/GalleryProvider;", "mOriginalFile", "loadBundle", "", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onRequestPermissionsResult", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "setCompressedImage", "file", "setCropImage", "setError", "message", "setImage", "setResult", "setResultCancel", "Companion", "imagepicker_release"})
public final class ImagePickerActivity
extends FragmentActivity {
    private GalleryProvider mGalleryProvider;
    private CameraProvider mCameraProvider;
    private CropProvider mCropProvider;
    private CompressionProvider mCompressionProvider;
    private File mOriginalFile;
    private File mCropFile;
    private static final String TAG = "image_picker";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.loadBundle();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void loadBundle() {
        ImageProvider provider;
        Bundle bundle;
        this.mCropProvider = new CropProvider(this);
        this.mCompressionProvider = new CompressionProvider(this);
        Intent intent = this.getIntent();
        Bundle bundle2 = bundle = intent != null ? intent.getExtras() : null;
        ImageProvider imageProvider = provider = (ImageProvider)((Object)(bundle2 != null ? bundle2.getSerializable("extra.image_provider") : null));
        if (imageProvider != null) {
            switch (ImagePickerActivity$WhenMappings.$EnumSwitchMapping$0[imageProvider.ordinal()]) {
                case 1: {
                    GalleryProvider galleryProvider = this.mGalleryProvider = new GalleryProvider(this);
                    if (galleryProvider == null) return;
                    galleryProvider.startIntent();
                    return;
                }
                case 2: {
                    CameraProvider cameraProvider = this.mCameraProvider = new CameraProvider(this);
                    if (cameraProvider == null) return;
                    cameraProvider.startIntent();
                    return;
                }
            }
        }
        Log.e((String)TAG, (String)"Image provider can not be null");
        String string2 = this.getString(R.string.error_task_cancelled);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(R.string.error_task_cancelled)");
        this.setError(string2);
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
            Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            CameraProvider cameraProvider = this.mCameraProvider;
            if (cameraProvider != null) {
                cameraProvider.onRequestPermissionsResult(requestCode);
            }
            GalleryProvider galleryProvider = this.mGalleryProvider;
            if (galleryProvider == null) break block1;
            galleryProvider.onRequestPermissionsResult(requestCode);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        CameraProvider cameraProvider = this.mCameraProvider;
        if (cameraProvider != null) {
            cameraProvider.onActivityResult(requestCode, resultCode, data);
        }
        GalleryProvider galleryProvider = this.mGalleryProvider;
        if (galleryProvider != null) {
            galleryProvider.onActivityResult(requestCode, resultCode, data);
        }
        CropProvider cropProvider = this.mCropProvider;
        if (cropProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCropProvider");
        }
        cropProvider.onActivityResult(requestCode, resultCode, data);
    }

    public void onBackPressed() {
        this.setResultCancel();
    }

    public final void setImage(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.mOriginalFile = file;
        CropProvider cropProvider = this.mCropProvider;
        if (cropProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCropProvider");
        }
        if (cropProvider.isCropEnabled()) {
            CropProvider cropProvider2 = this.mCropProvider;
            if (cropProvider2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCropProvider");
            }
            cropProvider2.startIntent(file);
        } else {
            CompressionProvider compressionProvider = this.mCompressionProvider;
            if (compressionProvider == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCompressionProvider");
            }
            if (compressionProvider.isCompressionRequired(file)) {
                CompressionProvider compressionProvider2 = this.mCompressionProvider;
                if (compressionProvider2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mCompressionProvider");
                }
                compressionProvider2.compress(file);
            } else {
                this.setResult(file);
            }
        }
    }

    public final void setCropImage(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.mCropFile = file;
        CameraProvider cameraProvider = this.mCameraProvider;
        if (cameraProvider != null) {
            CameraProvider cameraProvider2 = cameraProvider;
            boolean bl = false;
            boolean bl2 = false;
            CameraProvider it = cameraProvider2;
            boolean bl3 = false;
            File file2 = this.mOriginalFile;
            if (file2 != null) {
                file2.delete();
            }
            this.mOriginalFile = null;
        }
        CompressionProvider compressionProvider = this.mCompressionProvider;
        if (compressionProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCompressionProvider");
        }
        if (compressionProvider.isCompressionRequired(file)) {
            CompressionProvider compressionProvider2 = this.mCompressionProvider;
            if (compressionProvider2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mCompressionProvider");
            }
            compressionProvider2.compress(file);
        } else {
            this.setResult(file);
        }
    }

    public final void setCompressedImage(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        CameraProvider cameraProvider = this.mCameraProvider;
        if (cameraProvider != null) {
            CameraProvider cameraProvider2 = cameraProvider;
            boolean bl = false;
            boolean bl2 = false;
            CameraProvider it = cameraProvider2;
            boolean bl3 = false;
            File file2 = this.mOriginalFile;
            if (file2 != null) {
                file2.delete();
            }
        }
        File file3 = this.mCropFile;
        if (file3 != null) {
            file3.delete();
        }
        this.mCropFile = null;
        this.setResult(file);
    }

    private final void setResult(File file) {
        Intent intent = new Intent();
        intent.setData(Uri.fromFile((File)file));
        intent.putExtra("extra.file_path", file.getAbsolutePath());
        this.setResult(-1, intent);
        this.finish();
    }

    public final void setResultCancel() {
        this.setResult(0, Companion.getCancelledIntent$imagepicker_release((Context)this));
        this.finish();
    }

    public final void setError(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intent intent = new Intent();
        intent.putExtra("extra.error", message);
        this.setResult(64, intent);
        this.finish();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/dhaval2404/imagepicker/ImagePickerActivity$Companion;", "", "()V", "TAG", "", "getCancelledIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "getCancelledIntent$imagepicker_release", "imagepicker_release"})
    public static final class Companion {
        @NotNull
        public final Intent getCancelledIntent$imagepicker_release(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intent intent = new Intent();
            String message = context.getString(R.string.error_task_cancelled);
            intent.putExtra("extra.error", message);
            return intent;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

