/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import androidx.core.content.FileProvider;
import com.github.dhaval2404.imagepicker.R;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lcom/github/dhaval2404/imagepicker/util/IntentUtils;", "", "()V", "getCameraIntent", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "file", "Ljava/io/File;", "getGalleryIntent", "imagepicker_release"})
public final class IntentUtils {
    public static final IntentUtils INSTANCE;

    @NotNull
    public final Intent getGalleryIntent() {
        Intent intent = Build.VERSION.SDK_INT >= 19 ? new Intent("android.intent.action.OPEN_DOCUMENT") : new Intent("android.intent.action.PICK");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType("image/*");
        return intent;
    }

    @Nullable
    public final Intent getCameraIntent(@NotNull Context context, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (Build.VERSION.SDK_INT >= 24) {
            String authority = context.getPackageName() + context.getString(R.string.image_picker_provider_authority_suffix);
            Uri photoURI = FileProvider.getUriForFile((Context)context, (String)authority, (File)file);
            intent.putExtra("output", (Parcelable)photoURI);
        } else {
            intent.putExtra("output", (Parcelable)Uri.fromFile((File)file));
        }
        return intent;
    }

    private IntentUtils() {
    }

    static {
        IntentUtils intentUtils;
        INSTANCE = intentUtils = new IntentUtils();
    }
}

