/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.provider;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import com.github.dhaval2404.imagepicker.ImagePickerActivity;
import com.github.dhaval2404.imagepicker.R;
import com.github.dhaval2404.imagepicker.provider.BaseProvider;
import com.github.dhaval2404.imagepicker.util.FileUriUtils;
import com.github.dhaval2404.imagepicker.util.IntentUtils;
import com.github.dhaval2404.imagepicker.util.PermissionUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0013\u001a\u00020\nH\u0002J\u0006\u0010\u0014\u001a\u00020\nR\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/GalleryProvider;", "Lcom/github/dhaval2404/imagepicker/provider/BaseProvider;", "activity", "Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;", "(Lcom/github/dhaval2404/imagepicker/ImagePickerActivity;)V", "mimeTypes", "", "", "[Ljava/lang/String;", "checkPermission", "", "handleResult", "data", "Landroid/content/Intent;", "onActivityResult", "requestCode", "", "resultCode", "onRequestPermissionsResult", "startGalleryIntent", "startIntent", "Companion", "imagepicker-support_release"})
public final class GalleryProvider
extends BaseProvider {
    private final String[] mimeTypes;
    private static final String[] REQUIRED_PERMISSIONS;
    private static final int GALLERY_INTENT_REQ_CODE = 4261;
    private static final int PERMISSION_INTENT_REQ_CODE = 4262;
    public static final Companion Companion;

    public final void startIntent() {
        this.checkPermission();
    }

    private final void checkPermission() {
        if (!PermissionUtil.INSTANCE.isPermissionGranted((Context)this, REQUIRED_PERMISSIONS)) {
            ActivityCompat.requestPermissions((Activity)((Activity)this.getActivity()), (String[])REQUIRED_PERMISSIONS, (int)4262);
        } else {
            this.startGalleryIntent();
        }
    }

    private final void startGalleryIntent() {
        Intent galleryIntent = IntentUtils.INSTANCE.getGalleryIntent((Context)this.getActivity(), this.mimeTypes);
        this.getActivity().startActivityForResult(galleryIntent, 4261);
    }

    public final void onRequestPermissionsResult(int requestCode) {
        if (requestCode == 4262) {
            if (PermissionUtil.INSTANCE.isPermissionGranted((Context)this, REQUIRED_PERMISSIONS)) {
                this.startGalleryIntent();
            } else {
                String string2 = this.getString(R.string.permission_gallery_denied);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"getString(R.string.permission_gallery_denied)");
                this.setError(string2);
            }
        }
    }

    public final void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 4261) {
            if (resultCode == -1) {
                this.handleResult(data);
            } else {
                this.setResultCancel();
            }
        }
    }

    private final void handleResult(Intent data) {
        Uri uri;
        Intent intent = data;
        Object object = uri = intent != null ? intent.getData() : null;
        if (uri != null) {
            String filePath = FileUriUtils.INSTANCE.getRealPath((Context)this.getActivity(), uri);
            CharSequence charSequence = filePath;
            if (!(charSequence == null || charSequence.length() == 0)) {
                this.getActivity().setImage(new File(filePath));
            } else {
                this.setError(R.string.error_failed_pick_gallery_image);
            }
        } else {
            this.setError(R.string.error_failed_pick_gallery_image);
        }
    }

    public GalleryProvider(@NotNull ImagePickerActivity activity) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)activity), (String)"activity");
        super(activity);
        Intent intent = activity.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"activity.intent");
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            Intrinsics.throwNpe();
        }
        Bundle bundle2 = bundle;
        GalleryProvider galleryProvider = this;
        String[] stringArray = bundle2.getStringArray("extra.mime_types");
        if (stringArray == null) {
            GalleryProvider galleryProvider2 = galleryProvider;
            String[] stringArray2 = new String[]{};
            galleryProvider = galleryProvider2;
            stringArray = stringArray2;
        }
        galleryProvider.mimeTypes = stringArray;
    }

    static {
        Companion = new Companion(null);
        REQUIRED_PERMISSIONS = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/github/dhaval2404/imagepicker/provider/GalleryProvider$Companion;", "", "()V", "GALLERY_INTENT_REQ_CODE", "", "PERMISSION_INTENT_REQ_CODE", "REQUIRED_PERMISSIONS", "", "", "[Ljava/lang/String;", "imagepicker-support_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

