/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.imagepicker.util;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J;\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/github/dhaval2404/imagepicker/util/FileUriUtils;", "", "()V", "getDataColumn", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getFilePath", "getRealPath", "isDownloadsDocument", "", "isExternalStorageDocument", "isGooglePhotosUri", "isMediaDocument", "imagepicker-support_release"})
public final class FileUriUtils {
    public static final FileUriUtils INSTANCE;

    @Nullable
    public final String getRealPath(@NotNull Context context, @NotNull Uri uri) {
        boolean isKitKat;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (this.isExternalStorageDocument(uri)) {
                String path;
                List list;
                Collection $receiver$iv;
                String docId;
                String string2 = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"docId");
                Object object = string2;
                String string3 = ":";
                string3 = new Regex(string3);
                int n = 0;
                object = string3.split((CharSequence)object, n);
                if (!$receiver$iv.isEmpty()) {
                    ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        CharSequence charSequence = it;
                        if (charSequence.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $receiver$iv = list;
                Collection collection = $receiver$iv;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                String string4 = StringsKt.equals((String)"primary", (String)type, (boolean)true) ? (split.length > 1 ? Environment.getExternalStorageDirectory().toString() + "/" + split[1] : Environment.getExternalStorageDirectory().toString() + "/") : (new File(path = "storage/" + StringsKt.replace$default((String)docId, (String)":", (String)"/", (boolean)false, (int)4, null)).exists() ? path : "/storage/sdcard/" + split[1]);
                return string4;
            }
            if (this.isDownloadsDocument(uri)) {
                String fileName = this.getFilePath(context, uri);
                if (fileName != null) {
                    return Environment.getExternalStorageDirectory().toString() + "/Download/" + fileName;
                }
                String id2 = DocumentsContract.getDocumentId((Uri)uri);
                Uri uri2 = Uri.parse((String)"content://downloads/public_downloads");
                Long l = Long.valueOf(id2);
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"java.lang.Long.valueOf(id)");
                Uri contentUri = ContentUris.withAppendedId((Uri)uri2, (long)l);
                return this.getDataColumn(context, contentUri, null, null);
            }
            if (this.isMediaDocument(uri)) {
                List list;
                Collection $receiver$iv;
                String docId;
                String string5 = docId = DocumentsContract.getDocumentId((Uri)uri);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"docId");
                Object contentUri = string5;
                String path = ":";
                path = new Regex(path);
                int $i$f$toTypedArray = 0;
                contentUri = path.split((CharSequence)contentUri, $i$f$toTypedArray);
                if (!$receiver$iv.isEmpty()) {
                    ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl3 = false;
                        CharSequence charSequence = it;
                        if (charSequence.length() == 0) continue;
                        list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list = CollectionsKt.emptyList();
                }
                $receiver$iv = list;
                Collection collection = $receiver$iv;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] split = stringArray;
                String type = split[0];
                Uri contentUri2 = null;
                if (Intrinsics.areEqual((Object)"image", (Object)type)) {
                    contentUri2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if (Intrinsics.areEqual((Object)"video", (Object)type)) {
                    contentUri2 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if (Intrinsics.areEqual((Object)"audio", (Object)type)) {
                    contentUri2 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                String selection = "_id=?";
                String[] selectionArgs = new String[]{split[1]};
                return this.getDataColumn(context, contentUri2, selection, selectionArgs);
            }
        } else {
            String string6 = uri.getScheme();
            if (string6 == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.equals((String)"content", (String)string6, (boolean)true)) {
                return this.isGooglePhotosUri(uri) ? uri.getLastPathSegment() : this.getDataColumn(context, uri, null, null);
            }
            String string7 = uri.getScheme();
            if (string7 == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.equals((String)"file", (String)string7, (boolean)true)) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor;
        block5: {
            String string2;
            cursor = null;
            String column = "_data";
            String[] projection = new String[]{column};
            try {
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri2 = uri;
                if (uri2 == null) {
                    Intrinsics.throwNpe();
                }
                if ((cursor = contentResolver.query(uri2, projection, selection, selectionArgs, null)) == null || !cursor.moveToFirst()) break block5;
                int index = cursor.getColumnIndexOrThrow(column);
                string2 = cursor.getString(index);
            }
            catch (Throwable throwable) {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                throw throwable;
            }
            cursor.close();
            return string2;
        }
        Cursor cursor3 = cursor;
        if (cursor3 != null) {
            cursor3.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFilePath(Context context, Uri uri) {
        Cursor cursor;
        block4: {
            String string2;
            cursor = null;
            String[] projection = new String[]{"_display_name"};
            try {
                cursor = context.getContentResolver().query(uri, projection, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) break block4;
                int index = cursor.getColumnIndexOrThrow("_display_name");
                string2 = cursor.getString(index);
            }
            catch (Throwable throwable) {
                Cursor cursor2 = cursor;
                if (cursor2 != null) {
                    cursor2.close();
                }
                throw throwable;
            }
            cursor.close();
            return string2;
        }
        Cursor cursor3 = cursor;
        if (cursor3 != null) {
            cursor3.close();
        }
        return null;
    }

    private final boolean isExternalStorageDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
    }

    private final boolean isDownloadsDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }

    private final boolean isMediaDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    private final boolean isGooglePhotosUri(Uri uri) {
        return Intrinsics.areEqual((Object)"com.google.android.apps.photos.content", (Object)uri.getAuthority());
    }

    private FileUriUtils() {
    }

    static {
        FileUriUtils fileUriUtils;
        INSTANCE = fileUriUtils = new FileUriUtils();
    }
}

