/*
 * Decompiled with CFR 0.152.
 */
package com.github.dhaval2404.form_validation.rule;

import com.github.dhaval2404.form_validation.rule.BaseRule;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/dhaval2404/form_validation/rule/RegexRule;", "Lcom/github/dhaval2404/form_validation/rule/BaseRule;", "regex", "", "errorRes", "", "(Ljava/lang/String;I)V", "error", "(Ljava/lang/String;Ljava/lang/String;)V", "mRegex", "validate", "", "text", "Companion", "form_validation_release"})
public final class RegexRule
extends BaseRule {
    private String mRegex;
    @NotNull
    public static final String DIGIT_ONLY_PATTERN = "^\\d+$";
    @NotNull
    public static final String DECIMAL_ONLY_PATTERN = "^\\d*\\.\\d+$";
    @NotNull
    public static final String ALPHANUMERIC_PATTERN = "^[a-zA-Z0-9]*$";
    @NotNull
    public static final String USERNAME_PATTERN = "^[a-zA-Z0-9_-]{3,16}";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean validate(@Nullable String text) {
        return Companion.validate(this.mRegex, text);
    }

    public RegexRule(@NotNull String regex, int errorRes) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        super(errorRes);
        this.mRegex = "";
        this.mRegex = regex;
    }

    public RegexRule(@NotNull String regex, @NotNull String error) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        super(error);
        this.mRegex = "";
        this.mRegex = regex;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/github/dhaval2404/form_validation/rule/RegexRule$Companion;", "", "()V", "ALPHANUMERIC_PATTERN", "", "DECIMAL_ONLY_PATTERN", "DIGIT_ONLY_PATTERN", "USERNAME_PATTERN", "validate", "", "regex", "text", "form_validation_release"})
    public static final class Companion {
        public final boolean validate(@NotNull String regex, @Nullable String text) {
            Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
            CharSequence charSequence = text;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return false;
            }
            return Pattern.compile(regex).matcher(text).matches();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

