/*
 * Decompiled with CFR 0.152.
 */
package com.github.dewinjm.monthyearpicker;

import android.view.View;
import android.widget.NumberPicker;
import com.github.dewinjm.monthyearpicker.IPickerView;
import com.github.dewinjm.monthyearpicker.PickerField;
import com.github.dewinjm.monthyearpicker.R;
import java.util.Arrays;
import java.util.Calendar;

public class PickerView
implements IPickerView {
    private final NumberPicker monthSpinner;
    private final NumberPicker yearSpinner;
    private String[] shortMonths;

    PickerView(View view) {
        this.monthSpinner = (NumberPicker)view.findViewById(R.id.myp_month);
        this.monthSpinner.setMinValue(0);
        this.monthSpinner.setOnLongPressUpdateInterval(200L);
        this.yearSpinner = (NumberPicker)view.findViewById(R.id.myp_year);
        this.yearSpinner.setOnLongPressUpdateInterval(100L);
    }

    private void updateMonthSpinners(int max, int min, Calendar current) {
        this.monthSpinner.setDisplayedValues(null);
        this.monthSpinner.setMinValue(min);
        this.monthSpinner.setMaxValue(max);
        this.monthSpinner.setWrapSelectorWheel(min == 0);
        String[] displayedValues = Arrays.copyOfRange(this.shortMonths, this.monthSpinner.getMinValue(), this.monthSpinner.getMaxValue() + 1);
        this.monthSpinner.setDisplayedValues(displayedValues);
        this.monthSpinner.setValue(current.get(2));
    }

    private void updateYearSpinners(int max, int min, Calendar current) {
        this.yearSpinner.setMinValue(min);
        this.yearSpinner.setMaxValue(max);
        this.yearSpinner.setWrapSelectorWheel(false);
        this.yearSpinner.setValue(current.get(1));
    }

    @Override
    public void setNumberOfMonth(int numberOfMonths) {
        this.monthSpinner.setMaxValue(numberOfMonths);
    }

    @Override
    public void dateUpdate(PickerField field, int max, int min, Calendar current) {
        switch (field) {
            case YEAR: {
                this.updateYearSpinners(max, min, current);
                break;
            }
            case MONTH: {
                this.updateMonthSpinners(max, min, current);
            }
        }
    }

    @Override
    public void setShortMonth(String[] shortMonths) {
        this.shortMonths = shortMonths;
        this.monthSpinner.setDisplayedValues(shortMonths);
    }

    @Override
    public void setOnValueChanged(NumberPicker.OnValueChangeListener onValueChangeListener) {
        this.monthSpinner.setOnValueChangedListener(onValueChangeListener);
        this.yearSpinner.setOnValueChangedListener(onValueChangeListener);
    }

    @Override
    public NumberPicker getMonthSpinner() {
        return this.monthSpinner;
    }

    @Override
    public NumberPicker getYearSpinner() {
        return this.yearSpinner;
    }

    @Override
    public void monthSetValue(int month) {
        this.monthSpinner.setValue(month);
    }

    @Override
    public void yearSetValue(int year) {
        this.yearSpinner.setValue(year);
    }
}

