/*
 * Decompiled with CFR 0.152.
 */
package com.github.dewinjm.monthyearpicker;

import android.widget.NumberPicker;
import com.github.dewinjm.monthyearpicker.IPickerView;
import com.github.dewinjm.monthyearpicker.PickerField;
import com.github.dewinjm.monthyearpicker.Util;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;

public class Presenter
implements NumberPicker.OnValueChangeListener {
    static final int DEFAULT_START_YEAR = 1900;
    private static final int DEFAULT_END_YEAR = 2100;
    private Calendar tempDate;
    private Calendar currentDate;
    private Calendar minDate;
    private Calendar maxDate;
    private Locale currentLocale;
    private String[] shortMonths;
    private int numberOfMonths;
    private IPickerView pickerView;
    private OnDateChangedListener onDateChangedListener;

    Presenter(IPickerView pickerView) {
        this.setCurrentLocale(Locale.getDefault());
        this.pickerView = pickerView;
        pickerView.setShortMonth(this.shortMonths);
        pickerView.setOnValueChanged(this);
        pickerView.setNumberOfMonth(this.numberOfMonths - 1);
        this.tempDate.clear();
        this.tempDate.set(1900, 0, 1);
        this.setMinDate(this.tempDate.getTimeInMillis());
        this.tempDate.clear();
        this.tempDate.set(2100, 11, 31);
        this.setMaxDate(this.tempDate.getTimeInMillis());
        this.currentDate.setTimeInMillis(System.currentTimeMillis());
        this.init(this.currentDate.get(1), this.currentDate.get(2), null);
    }

    private void setCurrentLocale(Locale locale) {
        if (!locale.equals(this.currentLocale)) {
            this.currentLocale = locale;
        }
        this.tempDate = Util.getCalendarForLocale(this.tempDate, locale);
        this.minDate = Util.getCalendarForLocale(this.minDate, locale);
        this.maxDate = Util.getCalendarForLocale(this.maxDate, locale);
        this.currentDate = Util.getCalendarForLocale(this.currentDate, locale);
        this.numberOfMonths = this.tempDate.getActualMaximum(2) + 1;
        this.shortMonths = new DateFormatSymbols().getShortMonths();
        if (Util.isNumericMonths(this.shortMonths)) {
            this.shortMonths = new String[this.numberOfMonths];
            for (int i = 0; i < this.numberOfMonths; ++i) {
                this.shortMonths[i] = String.format(locale, "%d", i + 1);
            }
        }
    }

    public void onValueChange(NumberPicker numberPicker, int oldVal, int newVal) {
        this.tempDate.setTimeInMillis(this.currentDate.getTimeInMillis());
        if (numberPicker == this.pickerView.getMonthSpinner()) {
            if (oldVal == 11 && newVal == 0) {
                this.tempDate.add(2, 1);
            } else if (oldVal == 0 && newVal == 11) {
                this.tempDate.add(2, -1);
            } else {
                this.tempDate.add(2, newVal - oldVal);
            }
        } else if (numberPicker == this.pickerView.getYearSpinner()) {
            this.tempDate.set(1, newVal);
        } else {
            throw new IllegalArgumentException();
        }
        this.setDate(this.tempDate.get(1), this.tempDate.get(2));
        this.updateSpinners();
        this.notifyDateChanged();
    }

    void init(int year, int monthOfYear, OnDateChangedListener onDateChangedListener) {
        this.setDate(year, monthOfYear);
        this.updateSpinners();
        this.onDateChangedListener = onDateChangedListener;
    }

    public void setMinDate(long min) {
        this.tempDate.setTimeInMillis(min);
        if (this.tempDate.get(1) == this.minDate.get(1) && this.tempDate.get(6) != this.minDate.get(6)) {
            return;
        }
        this.minDate.setTimeInMillis(min);
        if (this.currentDate.before(this.minDate)) {
            this.currentDate.setTimeInMillis(this.minDate.getTimeInMillis());
        }
        this.updateSpinners();
    }

    public void setMaxDate(long max) {
        this.tempDate.setTimeInMillis(max);
        if (this.tempDate.get(1) == this.maxDate.get(1) && this.tempDate.get(6) != this.maxDate.get(6)) {
            return;
        }
        this.maxDate.setTimeInMillis(max);
        if (this.currentDate.after(this.maxDate)) {
            this.currentDate.setTimeInMillis(this.maxDate.getTimeInMillis());
        }
        this.updateSpinners();
    }

    private void setDate(int year, int month) {
        this.currentDate.set(1, year);
        this.currentDate.set(2, month);
        if (this.currentDate.before(this.minDate)) {
            this.currentDate.setTimeInMillis(this.minDate.getTimeInMillis());
        } else if (this.currentDate.after(this.maxDate)) {
            this.currentDate.setTimeInMillis(this.maxDate.getTimeInMillis());
        }
    }

    private void updateSpinners() {
        int monthMin = 0;
        int monthMax = 11;
        if (this.currentDate.equals(this.minDate)) {
            monthMin = this.currentDate.get(2);
            monthMax = this.currentDate.getActualMaximum(2);
        } else if (this.currentDate.equals(this.maxDate)) {
            monthMin = this.currentDate.getActualMinimum(2);
            monthMax = this.currentDate.get(2);
        }
        this.pickerView.dateUpdate(PickerField.MONTH, monthMax, monthMin, this.currentDate);
        this.pickerView.dateUpdate(PickerField.YEAR, this.maxDate.get(1), this.minDate.get(1), this.currentDate);
    }

    int getYear() {
        return this.currentDate.get(1);
    }

    int getMonth() {
        return this.currentDate.get(2);
    }

    private void notifyDateChanged() {
        if (this.onDateChangedListener != null) {
            this.onDateChangedListener.onDateChanged(this.getYear(), this.getMonth());
        }
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(int var1, int var2);
    }
}

