/*
 * Decompiled with CFR 0.152.
 */
package com.gigamole.library;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.Scroller;
import com.gigamole.library.R;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Random;

public class NavigationTabBar
extends View
implements ViewPager.OnPageChangeListener {
    private static final int INVALID_INDEX = -1;
    private static final int DEFAULT_ANIMATION_DURATION = 300;
    private static final int DEFAULT_INACTIVE_COLOR = Color.parseColor((String)"#9f90af");
    private static final int DEFAULT_ACTIVE_COLOR = -1;
    private static final float MIN_FRACTION = 0.0f;
    private static final float MAX_FRACTION = 1.0f;
    private static final float ACTIVE_ICON_SCALE_BY = 0.4f;
    private static final float ICON_SIZE_FRACTION = 0.35f;
    private RectF mBounds;
    private RectF mPointerBounds;
    private Bitmap mBitmap;
    private Canvas mCanvas;
    private Bitmap mIconsBitmap;
    private Canvas mIconsCanvas;
    private Bitmap mPointerBitmap;
    private Canvas mPointerCanvas;
    private Paint mPaint;
    private Paint mPointerPaint;
    private Paint mIconPaint;
    final Paint mIconPointerPaint;
    private ValueAnimator mAnimator;
    private ResizeInterpolator mResizeInterpolator;
    private int mAnimationDuration;
    private ArrayList<Model> mModels;
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mListener;
    private int mScrollState;
    private OnTabBarSelectedIndexListener mOnTabBarSelectedIndexListener;
    private Animator.AnimatorListener mAnimatorListener;
    private float mModelSize;
    private int mIconSize;
    private float mCornersRadius;
    private int mLastIndex;
    private int mIndex;
    private float mFraction;
    private float mStartPointerX;
    private float mEndPointerX;
    private float mPointerLeftTop;
    private float mPointerRightBottom;
    private boolean mIsViewPagerMode;
    private boolean mIsHorizontalOrientation;
    private boolean mIsResizeIn;
    private boolean mIsActionDown;
    private boolean mIsPointerActionDown;
    private boolean mIsSetIndexFromTabBar;
    private int mInactiveColor;
    private int mActiveColor;

    public NavigationTabBar(Context context) {
        this(context, null);
    }

    public NavigationTabBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigationTabBar(Context context, AttributeSet attrs, int defStyleAttr) {
        block10: {
            super(context, attrs, defStyleAttr);
            this.mBounds = new RectF();
            this.mPointerBounds = new RectF();
            this.mPaint = new Paint(1){
                {
                    this.setDither(true);
                    this.setStyle(Paint.Style.FILL);
                }
            };
            this.mPointerPaint = new Paint(1){
                {
                    this.setDither(true);
                    this.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
                }
            };
            this.mIconPaint = new Paint(1){
                {
                    this.setDither(true);
                }
            };
            this.mIconPointerPaint = new Paint(1){
                {
                    this.setStyle(Paint.Style.FILL);
                    this.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
                }
            };
            this.mAnimator = new ValueAnimator();
            this.mResizeInterpolator = new ResizeInterpolator();
            this.mModels = new ArrayList();
            this.mLastIndex = -1;
            this.setWillNotDraw(false);
            this.setLayerType(2, null);
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.NavigationTabBar);
            try {
                this.setInactiveColor(typedArray.getColor(R.styleable.NavigationTabBar_ntb_inactive_color, DEFAULT_INACTIVE_COLOR));
                this.setActiveColor(typedArray.getColor(R.styleable.NavigationTabBar_ntb_active_color, -1));
                this.setAnimationDuration(typedArray.getInteger(R.styleable.NavigationTabBar_ntb_animation_duration, 300));
                this.setCornersRadius(typedArray.getDimension(R.styleable.NavigationTabBar_ntb_corners_radius, 0.0f));
                this.mAnimator.setFloatValues(new float[]{0.0f, 1.0f});
                this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        NavigationTabBar.this.updateIndicatorPosition(((Float)animation.getAnimatedValue()).floatValue());
                    }
                });
                if (!this.isInEditMode()) break block10;
                String[] previewColors = null;
                try {
                    int previewColorsId = typedArray.getResourceId(R.styleable.NavigationTabBar_ntb_preview_colors, 0);
                    previewColors = previewColorsId == 0 ? null : typedArray.getResources().getStringArray(previewColorsId);
                }
                catch (Exception exception) {
                    previewColors = null;
                    exception.printStackTrace();
                }
                finally {
                    if (previewColors == null) {
                        previewColors = typedArray.getResources().getStringArray(R.array.default_preview);
                    }
                    for (String previewColor : previewColors) {
                        this.mModels.add(new Model(null, Color.parseColor((String)previewColor)));
                    }
                    this.requestLayout();
                }
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public int getAnimationDuration() {
        return this.mAnimationDuration;
    }

    public void setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
        this.mAnimator.setDuration((long)this.mAnimationDuration);
        this.resetScroller();
    }

    public ArrayList<Model> getModels() {
        return this.mModels;
    }

    public void setModels(ArrayList<Model> models) {
        this.mModels.clear();
        this.mModels = models;
        this.requestLayout();
    }

    public int getActiveColor() {
        return this.mActiveColor;
    }

    public void setActiveColor(int activeColor) {
        this.mActiveColor = activeColor;
        this.mIconPointerPaint.setColor(activeColor);
        this.postInvalidate();
    }

    public int getInactiveColor() {
        return this.mInactiveColor;
    }

    public void setInactiveColor(int inactiveColor) {
        this.mInactiveColor = inactiveColor;
        this.mIconPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(inactiveColor, PorterDuff.Mode.SRC_IN));
        this.postInvalidate();
    }

    public float getCornersRadius() {
        return this.mCornersRadius;
    }

    public void setCornersRadius(float cornersRadius) {
        this.mCornersRadius = cornersRadius;
        this.postInvalidate();
    }

    public OnTabBarSelectedIndexListener getOnTabBarSelectedIndexListener() {
        return this.mOnTabBarSelectedIndexListener;
    }

    public void setOnTabBarSelectedIndexListener(OnTabBarSelectedIndexListener onTabBarSelectedIndexListener) {
        this.mOnTabBarSelectedIndexListener = onTabBarSelectedIndexListener;
        if (this.mAnimatorListener == null) {
            this.mAnimatorListener = new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    if (NavigationTabBar.this.mOnTabBarSelectedIndexListener != null && !NavigationTabBar.this.mIsViewPagerMode) {
                        NavigationTabBar.this.mOnTabBarSelectedIndexListener.onStartTabSelected(NavigationTabBar.this.mIndex);
                    }
                }

                public void onAnimationEnd(Animator animation) {
                    if (NavigationTabBar.this.mOnTabBarSelectedIndexListener != null && !NavigationTabBar.this.mIsViewPagerMode) {
                        NavigationTabBar.this.mOnTabBarSelectedIndexListener.onEndTabSelected(NavigationTabBar.this.mIndex);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            };
        }
        this.mAnimator.removeListener(this.mAnimatorListener);
        this.mAnimator.addListener(this.mAnimatorListener);
    }

    public void setViewPager(ViewPager viewPager) {
        if (viewPager == null) {
            this.mIsViewPagerMode = false;
            return;
        }
        if (this.mViewPager == viewPager) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if (viewPager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not provide adapter instance.");
        }
        this.mIsViewPagerMode = true;
        this.mViewPager = viewPager;
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.resetScroller();
        this.postInvalidate();
    }

    public void setViewPager(ViewPager viewPager, int index) {
        this.setViewPager(viewPager);
        this.mIndex = index;
        if (this.mIsViewPagerMode) {
            this.mViewPager.setCurrentItem(index, true);
        }
        this.postInvalidate();
    }

    private void resetScroller() {
        if (this.mViewPager == null) {
            return;
        }
        try {
            Field scrollerField = ViewPager.class.getDeclaredField("mScroller");
            scrollerField.setAccessible(true);
            ResizeViewPagerScroller scroller = new ResizeViewPagerScroller(this.mViewPager.getContext());
            scrollerField.set(this.mViewPager, (Object)scroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    public int getModelIndex() {
        return this.mIndex;
    }

    public void setModelIndex(int index) {
        this.setModelIndex(index, false);
    }

    public void setModelIndex(int index, boolean force) {
        if (this.mAnimator.isRunning()) {
            return;
        }
        if (this.mModels.isEmpty()) {
            return;
        }
        if (index == this.mIndex) {
            return;
        }
        this.mIsResizeIn = (index = Math.max(0, Math.min(index, this.mModels.size() - 1))) < this.mIndex;
        this.mLastIndex = this.mIndex;
        this.mIndex = index;
        this.mIsSetIndexFromTabBar = true;
        if (this.mIsViewPagerMode) {
            if (this.mViewPager == null) {
                throw new IllegalStateException("ViewPager is null.");
            }
            this.mViewPager.setCurrentItem(index, true);
        }
        this.mStartPointerX = this.mPointerLeftTop;
        this.mEndPointerX = (float)this.mIndex * this.mModelSize;
        if (force) {
            this.updateIndicatorPosition(1.0f);
        } else {
            this.mAnimator.start();
        }
    }

    private void updateIndicatorPosition(float fraction) {
        this.mFraction = fraction;
        this.mPointerLeftTop = this.mStartPointerX + this.mResizeInterpolator.getResizeInterpolation(fraction, this.mIsResizeIn) * (this.mEndPointerX - this.mStartPointerX);
        this.mPointerRightBottom = this.mStartPointerX + this.mModelSize + this.mResizeInterpolator.getResizeInterpolation(fraction, !this.mIsResizeIn) * (this.mEndPointerX - this.mStartPointerX);
        this.postInvalidate();
    }

    public void notifyDataSetChanged() {
        this.postInvalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mAnimator.isRunning()) {
            return true;
        }
        if (this.mScrollState != 0) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.mIsActionDown = true;
                if (!this.mIsViewPagerMode) break;
                if (this.mIsHorizontalOrientation) {
                    this.mIsPointerActionDown = (int)(event.getX() / this.mModelSize) == this.mIndex;
                    break;
                }
                this.mIsPointerActionDown = (int)(event.getY() / this.mModelSize) == this.mIndex;
                break;
            }
            case 2: {
                if (this.mIsPointerActionDown) {
                    if (this.mIsHorizontalOrientation) {
                        this.mViewPager.setCurrentItem((int)(event.getX() / this.mModelSize), true);
                        break;
                    }
                    this.mViewPager.setCurrentItem((int)(event.getY() / this.mModelSize), true);
                    break;
                }
                if (this.mIsActionDown) break;
            }
            case 1: {
                if (this.mIsActionDown) {
                    if (this.mIsHorizontalOrientation) {
                        this.setModelIndex((int)(event.getX() / this.mModelSize));
                    } else {
                        this.setModelIndex((int)(event.getY() / this.mModelSize));
                    }
                }
            }
            default: {
                this.mIsPointerActionDown = false;
                this.mIsActionDown = false;
            }
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mModels.isEmpty() || width == 0 || height == 0) {
            return;
        }
        this.mBounds.set(0.0f, 0.0f, (float)width, (float)height);
        this.mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCanvas = new Canvas(this.mBitmap);
        this.mPointerBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mPointerCanvas = new Canvas(this.mPointerBitmap);
        this.mIconsBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mIconsCanvas = new Canvas(this.mIconsBitmap);
        if (width > height) {
            this.mIsHorizontalOrientation = true;
            this.mModelSize = (float)width / (float)this.mModels.size();
            this.mIconSize = (int)((this.mModelSize > (float)height ? (float)height : this.mModelSize) * 0.35f);
        } else {
            this.mIsHorizontalOrientation = false;
            this.mModelSize = (float)height / (float)this.mModels.size();
            this.mIconSize = (int)((this.mModelSize > (float)width ? (float)width : this.mModelSize) * 0.35f);
        }
        for (Model model : this.mModels) {
            float originalIconSize = model.mIcon.getWidth() > model.mIcon.getHeight() ? (float)model.mIcon.getWidth() : (float)model.mIcon.getHeight();
            model.mInactiveIconScale = (float)this.mIconSize / originalIconSize;
            model.mActiveIconScaleBy = model.mInactiveIconScale * 0.4f;
        }
        if (this.isInEditMode() || !this.mIsViewPagerMode) {
            this.mIsSetIndexFromTabBar = true;
            if (this.isInEditMode()) {
                this.mIndex = new Random().nextInt(this.mModels.size());
            }
            this.mEndPointerX = this.mStartPointerX = (float)this.mIndex * this.mModelSize;
            this.updateIndicatorPosition(1.0f);
        }
    }

    protected void onDraw(Canvas canvas) {
        int i;
        if (this.mCanvas == null || this.mPointerCanvas == null || this.mIconsCanvas == null) {
            return;
        }
        this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.mPointerCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.mIconsCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        for (i = 0; i < this.mModels.size(); ++i) {
            this.mPaint.setColor(this.mModels.get(i).mColor);
            if (this.mIsHorizontalOrientation) {
                float left = this.mModelSize * (float)i;
                float right = left + this.mModelSize;
                this.mCanvas.drawRect(left, 0.0f, right, this.mBounds.height(), this.mPaint);
                continue;
            }
            float top = this.mModelSize * (float)i;
            float bottom = top + this.mModelSize;
            this.mCanvas.drawRect(0.0f, top, this.mBounds.width(), bottom, this.mPaint);
        }
        if (this.mIsHorizontalOrientation) {
            this.mPointerBounds.set(this.mPointerLeftTop, 0.0f, this.mPointerRightBottom, this.mBounds.height());
        } else {
            this.mPointerBounds.set(0.0f, this.mPointerLeftTop, this.mBounds.width(), this.mPointerRightBottom);
        }
        if (this.mCornersRadius == 0.0f) {
            this.mPointerCanvas.drawRect(this.mPointerBounds, this.mPaint);
        } else {
            this.mPointerCanvas.drawRoundRect(this.mPointerBounds, this.mCornersRadius, this.mCornersRadius, this.mPaint);
        }
        this.mCanvas.drawBitmap(this.mPointerBitmap, 0.0f, 0.0f, this.mPointerPaint);
        for (i = 0; i < this.mModels.size(); ++i) {
            float matrixCenterY;
            float matrixCenterX;
            float topOffset;
            float leftOffset;
            Model model = this.mModels.get(i);
            if (this.mIsHorizontalOrientation) {
                leftOffset = this.mModelSize * (float)i + (this.mModelSize - (float)model.mIcon.getWidth()) * 0.5f;
                topOffset = (this.mBounds.height() - (float)model.mIcon.getHeight()) * 0.5f;
                matrixCenterX = leftOffset + (float)model.mIcon.getWidth() * 0.5f;
                matrixCenterY = topOffset + (float)model.mIcon.getHeight() * 0.5f;
            } else {
                leftOffset = (this.mBounds.width() - (float)model.mIcon.getWidth()) * 0.5f;
                topOffset = this.mModelSize * (float)i + (this.mModelSize - (float)model.mIcon.getHeight()) * 0.5f;
                matrixCenterX = leftOffset + (float)model.mIcon.getWidth() * 0.5f;
                matrixCenterY = topOffset + (float)model.mIcon.getHeight() * 0.5f;
            }
            model.mIconMatrix.setTranslate(leftOffset, topOffset);
            float matrixScale = model.mActiveIconScaleBy * this.mResizeInterpolator.getResizeInterpolation(this.mFraction, true);
            float matrixLastScale = model.mActiveIconScaleBy * this.mResizeInterpolator.getResizeInterpolation(this.mFraction, false);
            if (this.mIsSetIndexFromTabBar) {
                if (this.mIndex == i) {
                    model.mIconMatrix.postScale(model.mInactiveIconScale + matrixScale, model.mInactiveIconScale + matrixScale, matrixCenterX, matrixCenterY);
                } else if (this.mLastIndex == i) {
                    model.mIconMatrix.postScale(model.mInactiveIconScale + model.mActiveIconScaleBy - matrixLastScale, model.mInactiveIconScale + model.mActiveIconScaleBy - matrixLastScale, matrixCenterX, matrixCenterY);
                } else {
                    model.mIconMatrix.postScale(model.mInactiveIconScale, model.mInactiveIconScale, matrixCenterX, matrixCenterY);
                }
            } else if (i != this.mIndex && i != this.mIndex + 1) {
                model.mIconMatrix.postScale(model.mInactiveIconScale, model.mInactiveIconScale, matrixCenterX, matrixCenterY);
            } else if (i == this.mIndex + 1) {
                model.mIconMatrix.postScale(model.mInactiveIconScale + matrixScale, model.mInactiveIconScale + matrixScale, matrixCenterX, matrixCenterY);
            } else if (i == this.mIndex) {
                model.mIconMatrix.postScale(model.mInactiveIconScale + model.mActiveIconScaleBy - matrixLastScale, model.mInactiveIconScale + model.mActiveIconScaleBy - matrixLastScale, matrixCenterX, matrixCenterY);
            }
            this.mIconsCanvas.drawBitmap(model.mIcon, model.mIconMatrix, this.mIconPaint);
        }
        if (this.mCornersRadius == 0.0f) {
            this.mIconsCanvas.drawRect(this.mPointerBounds, this.mIconPointerPaint);
        } else {
            this.mIconsCanvas.drawRoundRect(this.mPointerBounds, this.mCornersRadius, this.mCornersRadius, this.mIconPointerPaint);
        }
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
        canvas.drawBitmap(this.mIconsBitmap, 0.0f, 0.0f, null);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (!this.mIsSetIndexFromTabBar) {
            this.mIsResizeIn = position < this.mIndex;
            this.mLastIndex = this.mIndex;
            this.mIndex = position;
            this.mStartPointerX = (float)position * this.mModelSize;
            this.mEndPointerX = this.mStartPointerX + this.mModelSize;
            this.updateIndicatorPosition(positionOffset);
        }
        if (this.mListener != null) {
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mScrollState == 0) {
            this.mIsResizeIn = position < this.mIndex;
            this.mLastIndex = this.mIndex;
            this.mIndex = position;
            this.postInvalidate();
        }
        if (this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 0) {
            this.mFraction = 0.0f;
            this.mIsSetIndexFromTabBar = false;
        }
        this.mScrollState = state;
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mIndex = savedState.index;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.index = this.mIndex;
        return savedState;
    }

    public static interface OnTabBarSelectedIndexListener {
        public void onStartTabSelected(int var1);

        public void onEndTabSelected(int var1);
    }

    private class ResizeInterpolator
    implements Interpolator {
        private final float mFactor = 1.0f;
        private boolean mResizeIn;

        private ResizeInterpolator() {
        }

        public float getInterpolation(float input) {
            if (this.mResizeIn) {
                return (float)(1.0 - Math.pow(1.0f - input, 2.0));
            }
            return (float)Math.pow(input, 2.0);
        }

        public float getResizeInterpolation(float input, boolean resizeIn) {
            this.mResizeIn = resizeIn;
            return this.getInterpolation(input);
        }
    }

    private class ResizeViewPagerScroller
    extends Scroller {
        public ResizeViewPagerScroller(Context context) {
            super(context, (Interpolator)new AccelerateDecelerateInterpolator());
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            super.startScroll(startX, startY, dx, dy, NavigationTabBar.this.mAnimationDuration);
        }

        public void startScroll(int startX, int startY, int dx, int dy) {
            super.startScroll(startX, startY, dx, dy, NavigationTabBar.this.mAnimationDuration);
        }
    }

    public static class Model {
        private int mColor;
        private Bitmap mIcon;
        private Matrix mIconMatrix = new Matrix();
        private float mInactiveIconScale;
        private float mActiveIconScaleBy;

        public Model(Drawable icon, int color) {
            this.mColor = color;
            this.mIcon = icon != null ? ((BitmapDrawable)icon).getBitmap() : Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.RGB_565);
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int index;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.index = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.index);
        }
    }
}

