/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CaseInsensitiveMap<V>
implements Map<String, V> {
    private Map<String, String> originalKeys = new HashMap<String, String>();
    private Map<String, V> delegate = new org.apache.commons.collections4.map.CaseInsensitiveMap();

    public CaseInsensitiveMap() {
    }

    public CaseInsensitiveMap(Map<? extends String, ? extends V> m) {
        this();
        this.putAll((Map<String, ? extends V>)m);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(String key, V value) {
        this.originalKeys.put(this.convertKey(key), key);
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        this.originalKeys.remove(this.convertKey(key));
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        for (String string : m.keySet()) {
            this.originalKeys.put(this.convertKey(string), string);
        }
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.originalKeys.clear();
        this.delegate.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.originalKeys.values());
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<Map.Entry<String, V>> es = new HashSet<Map.Entry<String, V>>();
        for (Map.Entry<String, V> e : this.delegate.entrySet()) {
            String oKey = this.originalKeys.get(this.convertKey(e.getKey()));
            es.add(new CIEntry(oKey, e.getValue()));
        }
        return es;
    }

    private String convertKey(Object key) {
        return key.toString().toUpperCase();
    }

    class CIEntry
    implements Map.Entry<String, V> {
        private String key;
        private V value;

        protected CIEntry(String key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.value = value;
            return value;
        }

        public String toString() {
            return String.format("%s=%s", this.key, this.value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }
}

