/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.query.compiler;

import cn.devezhao.persist4j.dialect.Dialect;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class JoinTree
implements Serializable {
    private static final long serialVersionUID = -868044162738823519L;
    static final String TABLE_ALIAS_PREFIX = "_t";
    static final String COLUMN_ALIAS_PREFIX = "_c";
    private JoinNode rootNode;
    private int tableIncrease;
    private String tableAliasPrefix;

    public JoinTree(String table) {
        this(table, -1);
    }

    public JoinTree(String table, int tableIncrease) {
        this(table, tableIncrease, TABLE_ALIAS_PREFIX);
    }

    public JoinTree(String table, int tableIncrease, String tableAliasPrefix) {
        this.rootNode = new JoinNode(table);
        this.tableIncrease = tableIncrease;
        this.tableAliasPrefix = tableAliasPrefix;
    }

    public JoinNode getRootJoinNode() {
        return this.rootNode;
    }

    public void addChildJoin(JoinNode node) {
        this.addChildJoin(node, this.rootNode);
    }

    public JoinNode addChildJoin(String table, String joinOnLeft, String joinOnRight) {
        return this.addChildJoin(table, joinOnLeft, joinOnRight, this.rootNode);
    }

    public void addChildJoin(JoinNode node, JoinNode parentNode) {
        parentNode.addChildJoin(node);
    }

    public JoinNode addChildJoin(String table, String joinOnLeft, String joinOnRight, JoinNode parentNode) {
        JoinNode node = this.hasEquallyNode(table, joinOnLeft, joinOnRight, parentNode);
        if (node == null) {
            node = new JoinNode(table, joinOnLeft, joinOnRight, parentNode);
            this.addChildJoin(node, parentNode);
        }
        return node;
    }

    public String toJoinsSQL(Dialect dialect) {
        StringBuilder sql = new StringBuilder();
        sql.append(this.rootNode.as(dialect));
        for (JoinNode node : this.rootNode.getChildJoins()) {
            sql.append(this.asJoinString(node, dialect));
        }
        return sql.toString();
    }

    private String asJoinString(JoinNode node, Dialect dialect) {
        StringBuilder joinSql = new StringBuilder();
        if (node.parentJoin.getAlias() == null) {
            joinSql.append(node.parentJoin.as(dialect));
        }
        joinSql.append(" left join ");
        if (node.getChildJoins().length > 0) {
            joinSql.append('(');
            for (JoinNode jNode : node.getChildJoins()) {
                joinSql.append(this.asJoinString(jNode, dialect));
            }
            joinSql.append(')');
        }
        if (node.getAlias() == null) {
            joinSql.append(node.as(dialect));
        }
        joinSql.append(" on ").append(node.parentJoin.getAlias()).append('.').append(dialect.quote(node.joinOnLeft)).append(" = ").append(node.getAlias()).append('.').append(dialect.quote(node.joinOnRight));
        return joinSql.toString();
    }

    private JoinNode hasEquallyNode(String table, String joinOnLeft, String joinOnRight, JoinNode parentNode) {
        if (parentNode == null) {
            return null;
        }
        for (JoinNode node : parentNode.getChildJoins()) {
            if (!node.table.equals(table) || !node.joinOnLeft.equals(joinOnLeft) || !parentNode.table.equals(node.parentJoin.table)) continue;
            return node;
        }
        return null;
    }

    private int getTableIncrease() {
        ++this.tableIncrease;
        return this.tableIncrease;
    }

    public class JoinNode
    implements Serializable {
        private static final long serialVersionUID = -9134659400293558001L;
        String table;
        String joinOnLeft;
        String joinOnRight;
        JoinNode parentJoin;
        Set<JoinNode> childJoins = new LinkedHashSet<JoinNode>();
        String alias;

        JoinNode(String table) {
            this.table = table;
        }

        JoinNode(String table, String joinOnLeft, String joinOnRight, JoinNode parentJoin) {
            this(table);
            this.joinOnLeft = joinOnLeft;
            this.joinOnRight = joinOnRight;
            this.parentJoin = parentJoin;
            parentJoin.addChildJoin(this);
        }

        void addChildJoin(JoinNode childJoin) {
            this.childJoins.add(childJoin);
        }

        String as(Dialect dialect) {
            this.alias = JoinTree.this.tableAliasPrefix + JoinTree.this.getTableIncrease();
            return String.format("%s as %s", dialect.quote(this.table), this.alias);
        }

        public String getAlias() {
            return this.alias;
        }

        JoinNode[] getChildJoins() {
            return this.childJoins.toArray(new JoinNode[0]);
        }

        public String toString() {
            if (this.parentJoin == null) {
                return String.format("<%s>", this.table);
            }
            return String.format("<%s, %s = %s, %s>", this.table, this.joinOnLeft, this.joinOnRight, this.parentJoin.table);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            return Objects.hash(this.table, this.joinOnLeft, this.joinOnRight);
        }
    }
}

