/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.query;

import cn.devezhao.persist4j.Record;
import cn.devezhao.persist4j.dialect.Editor;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.exception.SqlExceptionConverter;
import cn.devezhao.persist4j.query.AjqlQuery;
import cn.devezhao.persist4j.query.QueryException;
import cn.devezhao.persist4j.query.QueryedRecord;
import cn.devezhao.persist4j.query.Result;
import cn.devezhao.persist4j.query.SlowLogger;
import cn.devezhao.persist4j.query.compiler.JoinField;
import cn.devezhao.persist4j.query.compiler.ParameterItem;
import cn.devezhao.persist4j.query.compiler.SelectItem;
import cn.devezhao.persist4j.query.compiler.SelectItemType;
import cn.devezhao.persist4j.util.SqlHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class AjqlResultImpl
implements Result {
    private static final long serialVersionUID = -4514273807145664184L;
    private static final Log LOG = LogFactory.getLog(AjqlResultImpl.class);
    static final Object[][] EMPTY_OBJECT_ARRAYS = new Object[0][];
    private final AjqlQuery query;
    private List<Object[]> dataCache;
    private transient PreparedStatement pstmt;

    protected AjqlResultImpl(AjqlQuery query) {
        this.query = query;
    }

    @Override
    public Object[][] array() {
        if (this.execQuery(0).isEmpty()) {
            return EMPTY_OBJECT_ARRAYS;
        }
        return (Object[][])this.dataCache.toArray((T[])new Object[this.dataCache.size()][]);
    }

    @Override
    public Object[] unique() {
        this.query.setMaxResults(1);
        this.query.setLimit(1, this.query.offset);
        if (this.execQuery(1).isEmpty()) {
            return null;
        }
        return this.dataCache.get(0);
    }

    @Override
    public List<Record> list() {
        if (this.execQuery(0).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Record> records = new ArrayList<Record>();
        for (Object[] row : this.dataCache) {
            records.add(this.bindRecord(row));
        }
        return records;
    }

    @Override
    public Record record() {
        this.query.setMaxResults(1);
        this.query.setLimit(1, this.query.offset);
        if (this.execQuery(1).isEmpty()) {
            return null;
        }
        return this.bindRecord(this.dataCache.get(0));
    }

    @Override
    public Result reset() {
        if (this.dataCache != null) {
            this.dataCache = null;
        }
        return this;
    }

    protected List<Object[]> execQuery(int fetch) {
        if (this.dataCache != null) {
            return this.dataCache;
        }
        this.dataCache = new LinkedList<Object[]>();
        SelectItem[] selectItems = this.query.getSelectItems();
        Map<String, ParameterItem> inParamaters = this.query.getQueryCompiler().getInParameters();
        HashMap<ParameterItem, Object> paramatersMapping = null;
        if (!inParamaters.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Use in-paramaters : " + inParamaters));
            }
            paramatersMapping = new HashMap<ParameterItem, Object>();
            Map<String, Object> inParamatersRaw = this.query.getInParameters();
            for (Map.Entry<String, ParameterItem> e : inParamaters.entrySet()) {
                boolean index = e.getKey().charAt(0) != ':';
                Object pVal = index ? inParamatersRaw.get(e.getKey()) : inParamatersRaw.get(e.getKey().substring(1));
                if (pVal == null) {
                    throw new QueryException("The " + (index ? "index" : "named") + " parameter `" + e.getKey() + "` unset");
                }
                paramatersMapping.put(e.getValue(), pVal);
            }
        }
        String aSql = this.query.getQueryCompiler().getCompiledSql();
        if (this.query.limit > 0) {
            int offset = this.query.offset;
            aSql = this.query.getPersistManagerFactory().getDialect().insertLimit(aSql, this.query.limit, offset);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(">> " + aSql));
        }
        SlowLogger.start();
        Connection connection = DataSourceUtils.getConnection((DataSource)this.query.getPersistManagerFactory().getDataSource());
        ResultSet rs = null;
        try {
            this.pstmt = connection.prepareStatement(aSql, 1003, 1007);
            if (paramatersMapping != null && !paramatersMapping.isEmpty()) {
                for (Map.Entry e : paramatersMapping.entrySet()) {
                    ParameterItem pi = (ParameterItem)e.getKey();
                    pi.getField().getType().getFieldEditor().set(this.pstmt, pi.getIndex(), e.getValue());
                }
            }
            if (this.query.getTimeout() > 0) {
                this.pstmt.setQueryTimeout(this.query.getTimeout());
            }
            rs = this.pstmt.executeQuery();
            if (fetch > 0) {
                rs.setFetchSize(fetch);
            }
            if (this.query.getFirstResult() > 0) {
                rs.absolute(this.query.getFirstResult());
            }
            if (this.query.getMaxResults() <= 0) {
                while (rs.next()) {
                    this.dataCache.add(this.readRow(selectItems, rs));
                }
            } else {
                int current = 0;
                while (current++ < this.query.getMaxResults() && rs.next()) {
                    this.dataCache.add(this.readRow(selectItems, rs));
                }
            }
            SqlHelper.close(rs);
            SqlHelper.clear(this.pstmt);
        }
        catch (SQLException sqlex) {
            try {
                throw SqlExceptionConverter.convert(sqlex, "#AJQL_QUERY", aSql);
            }
            catch (Throwable throwable) {
                SqlHelper.close(rs);
                SqlHelper.close(this.pstmt);
                SqlHelper.close(connection, this.query.getPersistManagerFactory().getDataSource());
                SlowLogger.stop(this.query.getSlowLoggerTime(), this.dataCache.size(), aSql);
                throw throwable;
            }
        }
        SqlHelper.close(rs);
        SqlHelper.close(this.pstmt);
        SqlHelper.close(connection, this.query.getPersistManagerFactory().getDataSource());
        SlowLogger.stop(this.query.getSlowLoggerTime(), this.dataCache.size(), aSql);
        return this.dataCache;
    }

    protected Object[] readRow(SelectItem[] selectItems, ResultSet rs) throws SQLException {
        Object[] row = new Object[selectItems.length];
        for (SelectItem item : selectItems) {
            Editor editor;
            if (item.getType() == SelectItemType.Aggregator) {
                String aggregator = ((JoinField)item).getAggregator();
                editor = "COUNT".equalsIgnoreCase(aggregator) ? FieldType.LONG.getFieldEditor() : ("DATE_FORMAT".equalsIgnoreCase(aggregator) || "CONCAT".equalsIgnoreCase(aggregator) ? FieldType.STRING.getFieldEditor() : ("YEAR".contentEquals(aggregator) || "QUARTER".contentEquals(aggregator) || "MONTH".contentEquals(aggregator) || "WEEK".contentEquals(aggregator) || "DATE".contentEquals(aggregator) ? FieldType.INT.getFieldEditor() : item.getField().getType().getFieldEditor()));
                row[item.getIndex()] = editor.get(rs, item.getIndex() + 1);
                continue;
            }
            editor = item.getField().getType().getFieldEditor();
            Object value = editor.get(rs, item.getIndex() + 1);
            if (value == null) continue;
            row[item.getIndex()] = value;
        }
        return row;
    }

    private Record bindRecord(Object[] row) {
        QueryedRecord record = new QueryedRecord(this.query.getQueryCompiler().getRootEntity(), this.query.getPersistManagerFactory().getSQLExecutorContext());
        for (SelectItem item : this.query.getSelectItems()) {
            Object v = row[item.getIndex()];
            if (v == null) continue;
            record.setObject(item.getFieldPath(), v);
        }
        record.setSelectItems(this.query.getSelectItems());
        record.completeAfter();
        return record;
    }
}

