/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.engine;

import cn.devezhao.commons.ByteUtils;
import cn.devezhao.persist4j.engine.IDGenerator;
import cn.devezhao.persist4j.engine.WeakIDGenerator;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ID
implements Serializable {
    private static final long serialVersionUID = 5861261456599575527L;
    private static final Log LOG = LogFactory.getLog(ID.class);
    private static IDGenerator idGenerator;
    private static int idLength;
    public static final ID[] EMPTY_ID_ARRAY;
    private final int entityCode;
    private final String id;
    private Object label;

    public static ID newId(int typeCode) {
        Validate.isTrue((typeCode > -1 ? 1 : 0) != 0, (String)"entity code must be or 0-999");
        return new ID(idGenerator.generate(typeCode).toString());
    }

    public static boolean isId(Object id) {
        if (id instanceof ID) {
            return true;
        }
        if (id == null || StringUtils.isEmpty((String)id.toString()) || id.toString().length() != idLength) {
            return false;
        }
        return id.toString().charAt(3) == '-';
    }

    public static ID valueOf(String id) {
        if (!ID.isId(id)) {
            throw new IllegalArgumentException("Invaild id character: " + id);
        }
        return new ID(id);
    }

    public static IDGenerator getIDGenerator() {
        return idGenerator;
    }

    private ID(String id) {
        this.id = id.toLowerCase();
        this.entityCode = Integer.parseInt(id.substring(0, 3));
    }

    public Integer getEntityCode() {
        return this.entityCode;
    }

    public String toLiteral() {
        return this.id;
    }

    public void setLabel(Object label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label == null ? null : this.label.toString();
    }

    public Object getLabelRaw() {
        return this.label;
    }

    public String toString() {
        return this.toLiteral();
    }

    public int hashCode() {
        return ByteUtils.hash((int)this.id.hashCode());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ID)) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }

    static {
        String idClazz = StringUtils.defaultIfEmpty((String)System.getProperty("org.qdss.persist.id"), (String)WeakIDGenerator.class.getName());
        try {
            idGenerator = (IDGenerator)((Object)Class.forName(idClazz).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable ex) {
            LOG.error((Object)("Could't instance ID clazz: " + idClazz));
        }
        if (idGenerator == null) {
            idGenerator = new IDGenerator();
        }
        idLength = idGenerator.getLength();
        if (LOG.isInfoEnabled()) {
            LOG.warn((Object)("Using ID provider: " + ((Object)((Object)idGenerator)).getClass() + " (eg: " + idGenerator.generate(0) + ')'));
        }
        EMPTY_ID_ARRAY = new ID[0];
    }
}

