/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.dialect.editor;

import cn.devezhao.commons.ObjectUtils;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.dialect.editor.AbstractFieldEditor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DoubleEditor
extends AbstractFieldEditor {
    private static final long serialVersionUID = 3370417172932258927L;

    @Override
    public int getType() {
        return FieldType.DOUBLE.getMask();
    }

    @Override
    public void set(PreparedStatement pstmt, int index, Object value) throws SQLException {
        this.set(pstmt, index, value, 4);
    }

    public void set(PreparedStatement pstmt, int index, Object value, int scale) throws SQLException {
        BigDecimal decimalValue = value instanceof BigDecimal ? (BigDecimal)value : BigDecimal.valueOf((Double)value);
        double doubleValue = decimalValue.setScale(scale < 0 ? 4 : scale, RoundingMode.HALF_UP).doubleValue();
        pstmt.setDouble(index, doubleValue);
    }

    @Override
    public Object get(ResultSet rs, int index) throws SQLException {
        Object hasVal = rs.getObject(index);
        return hasVal == null ? null : Double.valueOf(ObjectUtils.toDouble((Object)hasVal));
    }
}

