/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.dialect.editor;

import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.dialect.editor.AbstractFieldEditor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DecimalEditor
extends AbstractFieldEditor {
    private static final long serialVersionUID = 3815050607620002543L;

    @Override
    public int getType() {
        return FieldType.DECIMAL.getMask();
    }

    @Override
    public void set(PreparedStatement pstmt, int index, Object value) throws SQLException {
        this.set(pstmt, index, value, 4);
    }

    public void set(PreparedStatement pstmt, int index, Object value, int scale) throws SQLException {
        if (value instanceof Double) {
            value = BigDecimal.valueOf((Double)value);
        }
        BigDecimal decimalValue = (BigDecimal)value;
        decimalValue = decimalValue.setScale(scale < 0 ? 4 : scale, RoundingMode.HALF_UP);
        pstmt.setBigDecimal(index, decimalValue);
    }

    @Override
    public Object get(ResultSet rs, int index) throws SQLException {
        return rs.getBigDecimal(index);
    }
}

