/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.dialect.editor;

import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.dialect.editor.CharEditor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BoolEditor
extends CharEditor {
    private static final long serialVersionUID = -2740602793905099065L;
    public static final char TRUE = 'T';
    public static final char FALSE = 'F';

    @Override
    public int getType() {
        return FieldType.BOOL.getMask();
    }

    @Override
    public void set(PreparedStatement pstmt, int index, Object value) throws SQLException {
        char ch = (Boolean)value != false ? (char)'T' : 'F';
        super.set(pstmt, index, Character.valueOf(ch));
    }

    @Override
    public Object get(ResultSet rs, int index) throws SQLException {
        Object v = super.get(rs, index);
        if (v == null) {
            return null;
        }
        char ch = v.toString().toUpperCase().charAt(0);
        switch (ch) {
            case 'T': {
                return true;
            }
            case 'F': {
                return false;
            }
        }
        return null;
    }
}

