/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.persist4j.dialect;

import cn.devezhao.persist4j.Field;
import cn.devezhao.persist4j.dialect.DialectException;
import cn.devezhao.persist4j.dialect.FieldType;
import cn.devezhao.persist4j.dialect.Type;
import cn.devezhao.persist4j.dialect.function.GetDateFunction;
import cn.devezhao.persist4j.dialect.function.SqlFunction;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Dialect
implements Serializable {
    private static final long serialVersionUID = 2651165738037766620L;
    protected static final Log LOG = LogFactory.getLog(Dialect.class);
    protected static final char[] QUOTED = new char[]{'`', '`', '[', ']', '\"'};
    private final Set<Type> fieldTypes = new HashSet<Type>();
    private final Map<Integer, String> columnTypes = new HashMap<Integer, String>();
    private final Map<Integer, Integer> field2columnMappings = new HashMap<Integer, Integer>();
    private final Map<String, SqlFunction> sqlFunctions = new HashMap<String, SqlFunction>();

    protected Dialect() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Using dialect provider: " + this.getClass()));
        }
        this.registerFieldType(FieldType.PRIMARY);
        this.registerFieldType(FieldType.REFERENCE);
        this.registerFieldType(FieldType.ANY_REFERENCE);
        this.registerFieldType(FieldType.REFERENCE_LIST);
        this.registerFieldType(FieldType.INT);
        this.registerFieldType(FieldType.SMALL_INT);
        this.registerFieldType(FieldType.DOUBLE);
        this.registerFieldType(FieldType.DECIMAL);
        this.registerFieldType(FieldType.LONG);
        this.registerFieldType(FieldType.CHAR);
        this.registerFieldType(FieldType.STRING);
        this.registerFieldType(FieldType.TEXT);
        this.registerFieldType(FieldType.DATE);
        this.registerFieldType(FieldType.TIMESTAMP);
        this.registerFieldType(FieldType.TIME);
        this.registerFieldType(FieldType.BOOL);
        this.registerFieldType(FieldType.NTEXT);
        this.registerFieldType(FieldType.BINARY);
        this.registerSqlFunction(new GetDateFunction());
    }

    protected void registerFieldType(Type type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Register field type " + type));
        }
        this.fieldTypes.add(type);
    }

    protected void registerColumnType(int mask, String columnType, int sqlType) {
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("Register column(sql) type <" + mask + ':' + columnType + ">"));
        }
        this.columnTypes.put(mask, columnType);
        this.field2columnMappings.put(mask, sqlType);
    }

    public void registerSqlFunction(SqlFunction func) {
        String name = func.getToken().toUpperCase();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Register sql function: $" + name + " > " + func.getClass()));
        }
        if (this.sqlFunctions.containsKey(name)) {
            LOG.warn((Object)("Overlay function: " + name));
        }
        this.sqlFunctions.put(name, func);
    }

    public Type getFieldType(int mask) {
        for (Type tt : this.fieldTypes) {
            if (tt.getMask() != mask) continue;
            return tt;
        }
        throw new DialectException("No field type defined by mask: " + mask);
    }

    public Type getFieldType(String shortName) {
        for (Type tt : this.fieldTypes) {
            if (!tt.getName().equalsIgnoreCase(shortName)) continue;
            return tt;
        }
        throw new DialectException("No field type defined by short name: " + shortName);
    }

    public String getColumnType(int mask) {
        String ct = this.columnTypes.get(mask);
        if (ct == null) {
            throw new DialectException("No column type defined: " + mask);
        }
        return ct;
    }

    public int getSqlType(int mask) {
        Integer sqlt = this.field2columnMappings.get(mask);
        if (sqlt == null) {
            throw new DialectException("No sql type mapping for mask: " + mask);
        }
        return sqlt;
    }

    public SqlFunction getSqlFunction(String name) {
        SqlFunction func = this.sqlFunctions.get(name.toUpperCase());
        if (func == null) {
            throw new DialectException("No sql function defined: " + name);
        }
        return func;
    }

    public String generateColumnDDL(Field field, Integer length) {
        String cType = this.columnTypes.get(field.getType().getMask());
        if (cType.contains("%d")) {
            cType = String.format(cType, length);
        }
        String ddl = String.format("%s %s %s", field.getPhysicalName(), cType, field.isNullable() ? "" : "not null");
        if (FieldType.PRIMARY == field.getType()) {
            return ddl + " primary key";
        }
        return ddl;
    }

    public String quote(String field) {
        return this.getStartQuote() + field.trim() + this.getClosedQuote();
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public boolean supportsFullText() {
        return false;
    }

    public abstract String getDialectName();

    public abstract char getStartQuote();

    public abstract char getClosedQuote();

    public abstract String insertLimit(String var1, int var2, int var3);

    public String toString() {
        return this.getDialectName();
    }
}

