/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.momentjava.util;

import cn.devezhao.momentjava.util.MomentException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class I18nUtils {
    private static final Map<String, JSONObject> RESCACHED = new HashMap<String, JSONObject>();

    public static String string(String locale, String key) {
        JSONObject res = I18nUtils.loadResource(locale);
        return res.getString(key);
    }

    private static JSONObject loadResource(String locale) {
        if (RESCACHED.containsKey(locale)) {
            return RESCACHED.get(locale);
        }
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String l;
            is = I18nUtils.class.getClassLoader().getResourceAsStream("i18n/" + locale + ".json");
            if (is == null) {
                throw new FileNotFoundException();
            }
            isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            br = new BufferedReader(isr);
            while ((l = br.readLine()) != null) {
                sb.append(l);
            }
        }
        catch (FileNotFoundException e) {
            throw new MomentException("\u65e0\u6548 locale \u8d44\u6e90: " + locale);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        JSONObject res = JSON.parseObject((String)sb.toString());
        RESCACHED.put(locale, res);
        return res;
    }
}

