/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.momentjava;

import cn.devezhao.momentjava.spec.MomentBase;
import cn.devezhao.momentjava.spec.MomentCalendar;
import cn.devezhao.momentjava.spec.MomentFormat;
import cn.devezhao.momentjava.spec.MomentLocale;
import cn.devezhao.momentjava.spec.MomentRelative;
import cn.devezhao.momentjava.util.DateUtils;
import cn.devezhao.momentjava.util.I18nUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MomentDelegate
implements MomentBase<MomentDelegate>,
MomentRelative<MomentDelegate>,
MomentLocale<MomentDelegate>,
MomentFormat,
MomentCalendar<MomentDelegate> {
    private static String defaultLocale = "zh_CN";
    private static String defaultFormat = "yyyy-MM-dd HH:mm:ss";
    private Calendar dateRaw;
    private String locale = defaultLocale;
    private String format = defaultFormat;
    private static final Map<String, Integer> UNIT2INT_MAP = new HashMap<String, Integer>();

    protected MomentDelegate() {
        this.dateRaw = Calendar.getInstance();
    }

    protected MomentDelegate(String source) {
        this();
        this.dateRaw.setTime(DateUtils.parse(source));
    }

    protected MomentDelegate(String source, String pattern) {
        this();
        this.dateRaw.setTime(DateUtils.parse(source, pattern));
    }

    protected MomentDelegate(Date date) {
        this.dateRaw = DateUtils.calendar(date);
    }

    protected static void config(String locale, String format) {
        defaultLocale = locale;
        defaultFormat = format;
    }

    @Override
    public MomentDelegate startOf(String unit) {
        if (!UNIT2INT_MAP.containsKey(unit)) {
            throw new IllegalArgumentException("Invalid time unit : " + unit);
        }
        this.dateRaw.set(14, 0);
        int month = this.dateRaw.get(2);
        int week = this.dateRaw.get(7);
        int unit2Int = UNIT2INT_MAP.get(unit);
        if (unit2Int < 6) {
            this.dateRaw.set(13, 0);
        }
        if (unit2Int < 5) {
            this.dateRaw.set(12, 0);
        }
        if (unit2Int < 4) {
            this.dateRaw.set(11, 0);
        }
        if (unit2Int < 3) {
            this.dateRaw.set(5, 1);
        }
        if (unit2Int < 2) {
            this.dateRaw.set(2, 0);
        }
        switch (unit) {
            case "quarter": 
            case "Q": {
                if (month < 3) {
                    this.dateRaw.set(2, 0);
                    break;
                }
                if (month < 6) {
                    this.dateRaw.set(2, 3);
                    break;
                }
                if (month < 9) {
                    this.dateRaw.set(2, 6);
                    break;
                }
                this.dateRaw.set(2, 9);
                break;
            }
            case "week": 
            case "W": {
                this.dateRaw.set(7, 1);
                this.dateRaw.add(5, 1);
                if (week != 1) break;
                this.dateRaw.add(6, -7);
            }
        }
        return this;
    }

    @Override
    public MomentDelegate endOf(String unit) {
        if (!UNIT2INT_MAP.containsKey(unit)) {
            throw new IllegalArgumentException("Invalid time unit : " + unit);
        }
        this.dateRaw.set(14, 999);
        int month = this.dateRaw.get(2);
        int week = this.dateRaw.get(7);
        int unit2Int = UNIT2INT_MAP.get(unit);
        if (unit2Int < 6) {
            this.dateRaw.set(13, 59);
        }
        if (unit2Int < 5) {
            this.dateRaw.set(12, 59);
        }
        if (unit2Int < 4) {
            this.dateRaw.set(11, 23);
        }
        if (unit2Int < 3) {
            this.dateRaw.set(5, 1);
            this.dateRaw.add(2, 1);
            this.dateRaw.add(5, -1);
        }
        if (unit2Int < 2) {
            this.dateRaw.set(2, 11);
        }
        switch (unit) {
            case "quarter": 
            case "Q": {
                if (month < 3) {
                    this.dateRaw.set(2, 2);
                } else if (month < 6) {
                    this.dateRaw.set(2, 5);
                } else if (month < 9) {
                    this.dateRaw.set(2, 8);
                } else {
                    this.dateRaw.set(2, 11);
                }
                if (this.dateRaw.get(5) != 1) break;
                this.dateRaw.add(5, -1);
                break;
            }
            case "week": 
            case "W": {
                if (week == 1) break;
                this.dateRaw.set(7, 0);
                this.dateRaw.add(5, 1);
            }
        }
        return this;
    }

    @Override
    public String fromNow() {
        long nowLeft = this.dateRaw.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
        String inago = nowLeft < 0L ? I18nUtils.string(this.locale(), "RelativeTime.past") : I18nUtils.string(this.locale(), "RelativeTime.future");
        nowLeft = Math.abs(nowLeft);
        if ((nowLeft /= 1000L) < 45L) {
            return String.format(inago, I18nUtils.string(this.locale(), "RelativeTime.s"));
        }
        if (nowLeft < 90L) {
            return String.format(inago, I18nUtils.string(this.locale(), "RelativeTime.m"));
        }
        if ((nowLeft /= 60L) < 45L) {
            String time = String.format(I18nUtils.string(this.locale(), "RelativeTime.mm"), nowLeft);
            return String.format(inago, time);
        }
        if (nowLeft < 90L) {
            return String.format(inago, I18nUtils.string(this.locale(), "RelativeTime.h"));
        }
        if (nowLeft <= 1260L) {
            String time = String.format(I18nUtils.string(this.locale(), "RelativeTime.hh"), (int)(nowLeft / 60L));
            return String.format(inago, time);
        }
        if ((nowLeft /= 60L) < 36L) {
            return String.format(inago, I18nUtils.string(this.locale(), "RelativeTime.d"));
        }
        if (nowLeft <= 624L) {
            String time = String.format(I18nUtils.string(this.locale(), "RelativeTime.dd"), (int)(nowLeft / 24L));
            return String.format(inago, time);
        }
        if ((nowLeft /= 24L) < 45L) {
            return String.format(inago, I18nUtils.string(this.locale(), "RelativeTime.M"));
        }
        if (nowLeft < 345L) {
            String time = String.format(I18nUtils.string(this.locale(), "RelativeTime.MM"), (int)(nowLeft / 30L));
            return String.format(inago, time);
        }
        if ((nowLeft /= 30L) < 18L) {
            return String.format(inago, I18nUtils.string(this.locale(), "RelativeTime.y"));
        }
        String time = String.format(I18nUtils.string(this.locale(), "RelativeTime.yy"), (int)(nowLeft / 12L));
        return String.format(inago, time);
    }

    @Override
    public String locale() {
        return this.locale;
    }

    @Override
    public MomentDelegate locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Override
    public String format() {
        return this.format(this.format);
    }

    @Override
    public String format(String pattern) {
        return new SimpleDateFormat(pattern).format(this.date());
    }

    @Override
    public MomentDelegate subtract(int amount, String unit) {
        return this.add(-amount, unit);
    }

    @Override
    public MomentDelegate add(int amount, String unit) {
        if (unit.endsWith("s")) {
            unit = unit.substring(0, unit.length() - 2);
        }
        switch (unit) {
            case "year": 
            case "Y": {
                this.dateRaw.add(1, amount);
                break;
            }
            case "quarter": 
            case "Q": {
                this.dateRaw.add(2, amount * 3);
                break;
            }
            case "month": 
            case "M": {
                this.dateRaw.add(2, amount);
                break;
            }
            case "week": 
            case "W": {
                this.dateRaw.add(7, amount * 7);
                break;
            }
            case "day": 
            case "D": {
                this.dateRaw.add(5, amount);
                break;
            }
            case "hour": 
            case "h": {
                this.dateRaw.add(11, amount);
                break;
            }
            case "minute": 
            case "m": {
                this.dateRaw.add(12, amount);
                break;
            }
            case "second": 
            case "s": {
                this.dateRaw.add(13, amount);
                break;
            }
            case "millisecond": 
            case "ms": {
                this.dateRaw.add(14, amount);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid time unit : " + unit);
            }
        }
        return this;
    }

    @Override
    public String calendar() {
        int dayLeft = DateUtils.getDayLeft(this.date());
        String time = new SimpleDateFormat(" HH:mm:ss").format(this.date());
        if (dayLeft == 0) {
            return I18nUtils.string(this.locale(), "Calendar.today") + time;
        }
        if (dayLeft == 1) {
            return I18nUtils.string(this.locale(), "Calendar.tomorrow") + time;
        }
        if (dayLeft == -1) {
            return I18nUtils.string(this.locale(), "Calendar.yesterday") + time;
        }
        return new SimpleDateFormat(this.format).format(this.date());
    }

    @Override
    public Date date() {
        return this.dateRaw.getTime();
    }

    public String toString() {
        return String.valueOf(this.dateRaw.getTime());
    }

    static {
        UNIT2INT_MAP.put("year", 1);
        UNIT2INT_MAP.put("Y", 1);
        UNIT2INT_MAP.put("month", 2);
        UNIT2INT_MAP.put("M", 2);
        UNIT2INT_MAP.put("day", 3);
        UNIT2INT_MAP.put("D", 3);
        UNIT2INT_MAP.put("hour", 4);
        UNIT2INT_MAP.put("h", 4);
        UNIT2INT_MAP.put("minute", 5);
        UNIT2INT_MAP.put("m", 5);
        UNIT2INT_MAP.put("second", 6);
        UNIT2INT_MAP.put("s", 6);
        UNIT2INT_MAP.put("millisecond", 7);
        UNIT2INT_MAP.put("ms", 7);
        UNIT2INT_MAP.put("quarter", 2);
        UNIT2INT_MAP.put("Q", 2);
        UNIT2INT_MAP.put("week", 3);
        UNIT2INT_MAP.put("W", 3);
    }
}

