/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.web;

import java.util.Enumeration;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class WebUtils {
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String ENCODING_GBK = "GBK";
    public static final String ENCODING_DEFAULT = "UTF-8";
    public static final String KEY_PREFIX = WebUtils.class.getPackage().getName() + "__";
    public static final String CURRENT_USER = KEY_PREFIX + "CURRENT_USER";
    public static final String REQUEST_MESSAGE = KEY_PREFIX + "REQUEST_MESSAGE";
    public static final int STATUS_OK = 0;
    public static final int STATUS_FAIL = 1;
    public static final int STATUS_ERROR = 2;

    public static void setMessage(ServletRequest request, String message) {
        request.setAttribute(REQUEST_MESSAGE, (Object)message);
    }

    public static String getMessage(ServletRequest request) {
        return (String)request.getAttribute(REQUEST_MESSAGE);
    }

    public static String dumpHeaders(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getHeader(name);
            sb.append(name).append('=').append(StringUtils.isBlank((String)value) ? "<blank>" : value).append("; ");
        }
        return sb.toString();
    }

    public static String dumpAttributes(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        Enumeration names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = request.getAttribute(name);
            sb.append(name).append('=').append(value == null ? "<null>" : value).append("; ");
        }
        return sb.toString();
    }

    public static String dumpParameters(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getParameter(name);
            sb.append(name).append('=').append((Object)(value == null ? "<null>" : value)).append("; ");
        }
        return sb.toString();
    }
}

