/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.web;

import cn.devezhao.commons.CalendarUtils;
import cn.devezhao.commons.CodecUtils;
import cn.devezhao.commons.xml.XMLHelper;
import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;

public class ServletUtils {
    public static final String INCLUDE_REQUEST_URI = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_PATH_INFO = "javax.servlet.include.path_info";
    public static final String INCLUDE_QUERY_STRING = "javax.servlet.include.query_string";
    public static final String FORWARD_REQUEST_URI = "javax.servlet.forward.request_uri";
    public static final String FORWARD_CONTEXT_PATH = "javax.servlet.forward.context_path";
    public static final String FORWARD_SERVLET_PATH = "javax.servlet.forward.servlet_path";
    public static final String FORWARD_PATH_INFO = "javax.servlet.forward.path_info";
    public static final String FORWARD_QUERY_STRING = "javax.servlet.forward.query_string";
    public static final String ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    public static final String ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String JSP_JSP_EXCEPTION = "javax.servlet.jsp.jspException";
    public static final String CT_PLAIN = "text/plain";
    public static final String CT_HTML = "text/html";
    public static final String CT_XML = "text/xml";
    public static final String CT_JS = "text/javascript";
    public static final String CT_JS_RFC4392 = "application/javascript";
    public static final String CT_JSON = "text/javascript";
    public static final String CT_JSON_RFC4627 = "application/json";

    public static String getParameter(ServletRequest request, String paramName) {
        return ServletUtils.getParameter(request, paramName, null);
    }

    public static String getParameter(ServletRequest request, String paramName, String defaultValue) {
        String value = request.getParameter(paramName);
        return value == null ? defaultValue : value;
    }

    public static HttpSession getSession(ServletRequest request) {
        return ServletUtils.getSession(request, true);
    }

    public static HttpSession getSession(ServletRequest request, boolean autoCreate) {
        return ((HttpServletRequest)request).getSession(autoCreate);
    }

    public static Object getSessionAttribute(ServletRequest request, String attrName) {
        return ServletUtils.getSessionAttribute(request, attrName, null);
    }

    public static Object getSessionAttribute(ServletRequest request, String attrName, Object defaultValue) {
        Object value = ServletUtils.getSession(request).getAttribute(attrName);
        return value == null ? defaultValue : value;
    }

    public static void setSessionAttribute(ServletRequest request, String attrName, Object value) {
        if (value == null) {
            ServletUtils.getSession(request, false).removeAttribute(attrName);
        } else {
            ServletUtils.getSession(request, true).setAttribute(attrName, value);
        }
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null && cookies[0] != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public static String readCookie(HttpServletRequest request, String cookieName) {
        Cookie cookie = ServletUtils.getCookie(request, cookieName);
        if (cookie == null) {
            return null;
        }
        String cookieValue = cookie.getValue();
        if (StringUtils.isBlank((String)cookieValue)) {
            return cookieValue;
        }
        return CodecUtils.urlDecode(cookieValue);
    }

    public static void addCookie(HttpServletResponse response, String cookieName, String cookieValue) {
        ServletUtils.addCookie(response, cookieName, cookieValue, 1209600, null, null);
    }

    public static void addCookie(HttpServletResponse response, String cookieName, String cookieValue, int maxAge, String domain, String path) {
        Cookie cookie = new Cookie(cookieName, CodecUtils.urlEncode(cookieValue));
        cookie.setMaxAge(maxAge);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        response.addCookie(cookie);
    }

    public static void removeCookie(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        Cookie cookie = ServletUtils.getCookie(request, cookieName);
        if (cookie == null) {
            return;
        }
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public static PrintWriter getWriter(HttpServletResponse response) {
        try {
            return response.getWriter();
        }
        catch (IOException ex) {
            throw new RuntimeException("Could't gets writer of response!", ex);
        }
    }

    public static void write(HttpServletResponse response, String output) {
        ServletUtils.getWriter(response).write(output);
    }

    public static void writeJson(HttpServletResponse response, String output) {
        ServletUtils.setContentType((ServletResponse)response, CT_JSON_RFC4627);
        ServletUtils.write(response, output);
    }

    public static Document getRequestDocument(ServletRequest request) throws IOException {
        BufferedReader reader = request.getReader();
        if (reader == null) {
            return null;
        }
        return XMLHelper.createDocument(reader, "UTF-8", true);
    }

    public static JSON getRequestJson(ServletRequest request) {
        String req = ServletUtils.getRequestString(request);
        return (JSON)JSON.parse((String)req);
    }

    public static String getRequestString(ServletRequest request) {
        BufferedReader br;
        try {
            br = request.getReader();
            if (br == null) {
                return null;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Could't gets reader of response!", ex);
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Could't read line of reader!", ex);
        }
        return sb.toString();
    }

    public static void setContentType(ServletResponse response, String contentType) {
        String encod = response.getCharacterEncoding();
        encod = StringUtils.isBlank((String)encod) ? "UTF-8" : encod;
        response.setContentType(contentType + "; charset=" + encod);
    }

    public static void forward(ServletRequest request, HttpServletResponse response, String path) {
        try {
            request.getRequestDispatcher(path).forward(request, (ServletResponse)response);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could't forward to url: " + path, ex);
        }
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("cache-control", "no-cache,no-store,max-age=0");
        response.addHeader("cache-control", "post-check=0, pre-check=0");
        response.setHeader("pragma", "no-cache");
    }

    public static String getRemoteAddr(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (StringUtils.isBlank((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isBlank((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isBlank((String)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.length() > 7) {
            if (ip.startsWith("::ffff:")) {
                ip = ip.substring(7);
            } else if ("0:0:0:0:0:0:0:1".equalsIgnoreCase(ip)) {
                ip = "127.0.0.1";
            }
        }
        return ip;
    }

    public static String getReferer(HttpServletRequest request) {
        return request.getHeader("referer");
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        String hv = request.getHeader("x-requested-with");
        return "XMLHttpRequest".equalsIgnoreCase(hv);
    }

    public static void addCacheHead(HttpServletResponse response, int minute) {
        response.setHeader("Cache-Control", "public, max-age=" + minute * 60);
        response.setDateHeader("Expires", CalendarUtils.add(minute, 12).getTime());
    }

    public static String getFullRequestUrl(HttpServletRequest request) {
        StringBuffer fullUrl = request.getRequestURL();
        String qstr = request.getQueryString();
        if (StringUtils.isNotBlank((String)qstr)) {
            fullUrl.append("?").append(qstr);
        }
        return fullUrl.toString();
    }

    public static String getScheme(HttpServletRequest request) {
        String scheme = request.getHeader("x-forwarded-proto");
        if (StringUtils.isBlank((String)scheme)) {
            scheme = request.getScheme();
        }
        return scheme;
    }
}

