/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.sql.builder;

import cn.devezhao.commons.sql.Builder;
import cn.devezhao.commons.sql.SqlHelper;
import java.util.LinkedList;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WhereClause
implements Builder {
    private static final Log LOG = LogFactory.getLog(WhereClause.class);
    private final Builder parentBuilder;
    private final LinkedList<String> caluseQueue = new LinkedList();
    private int previousAppendItem = 2;

    public WhereClause() {
        this(null);
    }

    public WhereClause(Builder parent) {
        this.parentBuilder = parent;
    }

    public WhereClause eq(String column, Object value) {
        this.addToCaluseQueue(column, "=", value);
        return this;
    }

    public WhereClause gt(String column, Object value) {
        this.addToCaluseQueue(column, ">", value);
        return this;
    }

    public WhereClause lt(String column, Object value) {
        this.addToCaluseQueue(column, "<", value);
        return this;
    }

    public WhereClause isnull(String column) {
        this.addToCaluseQueue(column, "is", ObjectUtils.NULL);
        return this;
    }

    public WhereClause isnotnull(String column) {
        this.addToCaluseQueue(column, "is not", ObjectUtils.NULL);
        return this;
    }

    public WhereClause like(String column, Object value) {
        this.addToCaluseQueue(column, "like", value);
        return this;
    }

    public WhereClause and() {
        if (this.previousAppendItem == 2) {
            LOG.warn((Object)"Previous append item is join item(or, and)");
        }
        this.previousAppendItem = 2;
        this.caluseQueue.add("and");
        return this;
    }

    public WhereClause or() {
        if (this.previousAppendItem == 2) {
            LOG.warn((Object)"Previous append item is join item(or, and)");
        }
        this.previousAppendItem = 2;
        this.caluseQueue.add("or");
        return this;
    }

    @Override
    public String toSql() {
        StringBuilder sql = new StringBuilder("( ");
        for (String s : this.caluseQueue) {
            sql.append(s).append(' ');
        }
        return sql.append(")").toString();
    }

    public String toFullSql() {
        return this.parentBuilder != null ? this.parentBuilder.toSql() : this.toSql();
    }

    private void addToCaluseQueue(String column, String operate, Object v) {
        if (this.previousAppendItem == 1) {
            LOG.warn((Object)"Previous append item is predication");
        }
        this.previousAppendItem = 1;
        this.caluseQueue.add(SqlHelper.wrapIdent(column));
        this.caluseQueue.add(operate);
        if (v == null) {
            this.caluseQueue.add("?");
        } else if (ObjectUtils.NULL == v) {
            this.caluseQueue.add("null");
        } else if (Number.class.isAssignableFrom(v.getClass())) {
            this.caluseQueue.add(v.toString());
        } else {
            this.caluseQueue.add('\'' + SqlHelper.escapeSql(v) + '\'');
        }
    }
}

