/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.sql.builder;

import cn.devezhao.commons.sql.SqlHelper;
import cn.devezhao.commons.sql.builder.ConditionalBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class UpdateBuilder
extends ConditionalBuilder {
    private final Map<String, Object> columns = new LinkedHashMap<String, Object>();

    public UpdateBuilder(String table) {
        super(table);
    }

    public UpdateBuilder addColumn(String column) {
        return this.addColumn(column, ObjectUtils.NULL);
    }

    public UpdateBuilder addColumn(String column, Object value) {
        if (value == null) {
            return this;
        }
        this.columns.put(column, value);
        return this;
    }

    @Override
    public String toSql() {
        StringBuilder sql = new StringBuilder("update ");
        sql.append(SqlHelper.wrapIdent(this.table.toLowerCase())).append(" set ");
        for (Map.Entry<String, Object> e : this.columns.entrySet()) {
            sql.append(SqlHelper.wrapIdent(e.getKey())).append(" = ");
            Object v = e.getValue();
            if (ObjectUtils.NULL == v) {
                sql.append("null");
            } else if (Number.class.isAssignableFrom(v.getClass())) {
                sql.append(v);
            } else {
                sql.append('\'').append(this.escapeSql(v)).append('\'');
            }
            sql.append(", ");
        }
        int len = sql.length();
        sql.delete(len - 2, len);
        sql.append(" where (1 = 1)");
        if (this.whereClause != null) {
            sql.append(" and ").append(this.whereClause.toSql());
        }
        if (!StringUtils.isBlank((String)this.whereString)) {
            sql.append(" and ").append(this.whereString);
        }
        return sql.toString();
    }

    public boolean hasColumn() {
        return !this.columns.isEmpty();
    }
}

