/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons.excel;

import cn.devezhao.commons.CalendarUtils;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.poi.ss.usermodel.DateUtil;

public class Cell
implements Serializable {
    private static final long serialVersionUID = -1590140578303295189L;
    public static final Cell NULL = new Cell(null);
    private final Object value;
    private final int rowNo;
    private final int columnNo;

    public Cell(Object value) {
        this(value, -1, -1);
    }

    public Cell(Object value, int rowNo, int columnNo) {
        this.value = value;
        this.rowNo = rowNo;
        this.columnNo = columnNo;
    }

    public int getRowNo() {
        return this.rowNo;
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public Object getRawValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == null || StringUtils.isEmpty((String)this.asString());
    }

    public String asString() {
        return this.asString(false);
    }

    public String asString(boolean trim) {
        return this.value == null ? null : (trim ? this.value.toString().trim() : this.value.toString());
    }

    public String toString() {
        return this.asString();
    }

    public Integer asInt() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        String istr = this.asString().replace(",", "");
        return NumberUtils.toInt((String)istr);
    }

    public Long asLong() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        String istr = this.asString().replace(",", "");
        return NumberUtils.toLong((String)istr);
    }

    public Double asDouble() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        String istr = this.asString(true).replace(",", "");
        return NumberUtils.toDouble((String)istr);
    }

    public Boolean asBool() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return BooleanUtils.toBoolean((String)this.asString(true));
    }

    public Date asDate() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.value instanceof Date) {
            return (Date)this.value;
        }
        String istr = this.asString(true);
        if (NumberUtils.isNumber((String)istr)) {
            double d = NumberUtils.toDouble((String)istr);
            return DateUtil.getJavaDate((double)d);
        }
        return CalendarUtils.parse(istr);
    }

    public Date asDate(String[] parsePatterns) {
        if (this.isEmpty()) {
            return null;
        }
        if (this.value instanceof Date) {
            return (Date)this.value;
        }
        String istr = this.asString(true);
        for (String pattern : parsePatterns) {
            Date d = CalendarUtils.parse(istr, pattern);
            if (d == null) continue;
            return d;
        }
        return null;
    }

    public static Cell valueOf(Object value, int rowNo, int columnNo) {
        return new Cell(value, rowNo, columnNo);
    }

    public static Cell valueOf(int rowNo, int columnNo) {
        return Cell.valueOf(null, rowNo, columnNo);
    }
}

