/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class RegexUtils {
    public static final Pattern EMAIL_PATTERN = Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    public static final Pattern URL_PATTERN = Pattern.compile("^(https?|ftp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
    public static final Pattern CNMOBILE_PATTERN = Pattern.compile("^(1[3-9][0-9])\\d{8}$");
    public static final Pattern TEL_PATTERN = Pattern.compile("[0-9\\-]{7,18}");

    public static boolean isEMail(String email) {
        return StringUtils.isNotBlank((String)email) && EMAIL_PATTERN.matcher(email).find() && !email.endsWith("yahoo.cn") && !email.endsWith("yahoo.com.cn") && !email.endsWith(".") && !email.startsWith(".") && StringUtils.countMatches((String)email, (String)"@") <= 1 && !email.contains("..");
    }

    public static boolean isUrl(String url) {
        return StringUtils.isNotBlank((String)url) && URL_PATTERN.matcher(url).find();
    }

    public static boolean isCNMobile(String mobile) {
        if (StringUtils.isBlank((String)mobile) || mobile.length() < 11) {
            return false;
        }
        if (mobile.startsWith("+86")) {
            mobile = mobile.substring(3);
        } else if (mobile.startsWith("86")) {
            mobile = mobile.substring(2);
        }
        return CNMOBILE_PATTERN.matcher(mobile).find();
    }

    public static boolean isTel(String tel) {
        if (StringUtils.isBlank((String)tel) || tel.length() < 7) {
            return false;
        }
        if (tel.startsWith("-") || tel.endsWith("-") || tel.contains("--")) {
            return false;
        }
        return TEL_PATTERN.matcher(tel).find();
    }
}

