/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.commons;

import cn.devezhao.commons.DateFormatUtils;
import java.text.DecimalFormat;

public class FormatUtils
extends DateFormatUtils {
    private static final char[] S_NUM = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
    private static final char[] S_UNIT = new char[]{'\u5206', '\u89d2', '\u5143', '\u62fe', '\u4f70', '\u4edf', '\u4e07', '\u62fe', '\u4f70', '\u4edf', '\u4ebf', '\u62fe', '\u4f70', '\u4edf', '\u4e07'};

    public static String formatNumber(Number number) {
        return new DecimalFormat(",###").format(number);
    }

    public static String formatDecimal(Number number) {
        return FormatUtils.formatDecimal(number, 2);
    }

    public static String formatDecimal(Number number, int scale) {
        String format = ",##0";
        if (scale > 0) {
            format = format + ".";
        }
        for (int i = 0; i < scale; ++i) {
            format = format + "0";
        }
        return new DecimalFormat(format).format(number);
    }

    public static String toChineseCurrency(double money) {
        boolean isNegative;
        boolean bl = isNegative = money < 0.0;
        if (isNegative) {
            money = Math.abs(money);
        }
        String str = String.valueOf(Math.round(money * 100.0 + 1.0E-5));
        String chs = "";
        for (int i = 0; i < str.length(); ++i) {
            int n = str.charAt(str.length() - 1 - i) - 48;
            chs = S_NUM[n] + "" + S_UNIT[i] + chs;
        }
        chs = chs.replaceAll("\u96f6\u4edf", "\u96f6");
        chs = chs.replaceAll("\u96f6\u4f70", "\u96f6");
        chs = chs.replaceAll("\u96f6\u62fe", "\u96f6");
        chs = chs.replaceAll("\u96f6\u4ebf", "\u4ebf");
        chs = chs.replaceAll("\u96f6\u4e07", "\u4e07");
        chs = chs.replaceAll("\u96f6\u5143", "\u5143");
        chs = chs.replaceAll("\u96f6\u89d2", "\u96f6");
        chs = chs.replaceAll("\u96f6\u5206", "\u96f6");
        chs = chs.replaceAll("\u96f6\u96f6", "\u96f6");
        chs = chs.replaceAll("\u96f6\u4ebf", "\u4ebf");
        chs = chs.replaceAll("\u96f6\u96f6", "\u96f6");
        chs = chs.replaceAll("\u96f6\u4e07", "\u4e07");
        chs = chs.replaceAll("\u96f6\u96f6", "\u96f6");
        chs = chs.replaceAll("\u96f6\u5143", "\u5143");
        chs = chs.replaceAll("\u4ebf\u4e07", "\u4ebf");
        chs = chs.replaceAll("\u96f6$", "");
        chs = chs.replaceAll("\u5143$", "\u5143\u6574");
        return isNegative ? "\u8d1f" + chs : chs;
    }
}

