/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.bizz.security.member;

import cn.devezhao.bizz.security.member.BusinessUnit;
import cn.devezhao.bizz.security.member.Member;
import cn.devezhao.bizz.security.member.Role;
import cn.devezhao.bizz.security.member.Team;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class User
extends Member
implements Principal {
    private static final long serialVersionUID = -5924320591430994214L;
    private Role owningRole;
    private BusinessUnit owningBizUnit;
    private final Set<Team> owningTeams = new HashSet<Team>(2);

    public User(Serializable identity, String name, boolean disabled) {
        super(identity, name, disabled);
    }

    public Role getOwningRole() {
        return this.owningRole;
    }

    public BusinessUnit getOwningBizUnit() {
        return this.owningBizUnit;
    }

    public Set<Team> getOwningTeams() {
        return Collections.unmodifiableSet(this.owningTeams);
    }

    public boolean isActive() {
        return !this.isDisabled() && this.owningRole != null && this.owningBizUnit != null;
    }

    protected void setOwningRole(Role owningRole) {
        this.owningRole = owningRole;
    }

    protected void setOwningBizUnit(BusinessUnit owningBizUnit) {
        this.owningBizUnit = owningBizUnit;
    }

    protected void joinTeam(Team team) {
        this.owningTeams.add(team);
    }

    protected void exitTeam(Team team) {
        this.owningTeams.remove(team);
    }
}

