/*
 * Decompiled with CFR 0.152.
 */
package cn.devezhao.bizz.security;

import cn.devezhao.bizz.privileges.DepthEntry;
import cn.devezhao.bizz.privileges.Permission;
import cn.devezhao.bizz.privileges.Privileges;
import cn.devezhao.bizz.privileges.impl.BizzDepthEntry;
import cn.devezhao.bizz.privileges.impl.BizzPermission;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EntityPrivileges
implements Privileges {
    private static final long serialVersionUID = -8141823128069571526L;
    private final Integer entity;
    private final String definition;
    private final Map<DepthEntry, Permission[]> dePermissions = new HashMap<DepthEntry, Permission[]>();
    private final Set<Permission> allPermissions = new HashSet<Permission>();

    public EntityPrivileges(Integer entity, String definition) {
        String[] depthValues;
        this.entity = entity;
        this.definition = definition;
        for (String dv : depthValues = definition.split(",")) {
            String[] dpVal = dv.split(":");
            Permission[] perms = BizzPermission.parse(Integer.parseInt(dpVal[1]));
            this.allPermissions.addAll(Arrays.asList(perms));
            this.dePermissions.put(BizzDepthEntry.parse(Integer.parseInt(dpVal[0])), perms);
        }
    }

    @Override
    public Serializable getIdentity() {
        return this.getEntity();
    }

    @Override
    public boolean allowed(Permission action) {
        return this.allPermissions.contains(action);
    }

    @Override
    public boolean allowed(Permission action, Serializable targetGuard) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DepthEntry superlative(Permission action) {
        HashSet<DepthEntry> set = new HashSet<DepthEntry>(this.dePermissions.size());
        block0: for (Map.Entry<DepthEntry, Permission[]> e : this.dePermissions.entrySet()) {
            for (Permission p : e.getValue()) {
                if (!action.equals(p)) continue;
                set.add(e.getKey());
                continue block0;
            }
        }
        if (set.isEmpty()) {
            return BizzDepthEntry.NONE;
        }
        DepthEntry sup = BizzDepthEntry.NONE;
        for (DepthEntry de : set) {
            if (de.getMask() > sup.getMask()) {
                sup = de;
            }
            if (!BizzDepthEntry.GLOBAL.equals(sup)) continue;
            return BizzDepthEntry.GLOBAL;
        }
        return sup;
    }

    public Integer getEntity() {
        return this.entity;
    }

    public String getDefinition() {
        return this.definition;
    }
}

