/*
 * Decompiled with CFR 0.152.
 */
package com.resources.view.recycler;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.resources.view.recycler.BaseSimpleRecyclerClickListener;
import com.resources.view.recycler.BaseViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseSimpleAdapter<Item, Holder extends BaseViewHolder>
extends RecyclerView.Adapter<BaseViewHolder> {
    protected BaseSimpleRecyclerClickListener<Item> mBaseSimpleRecyclerClickListener;
    public View.OnClickListener clickListener = new View.OnClickListener(){

        public void onClick(View v) {
            BaseSimpleAdapter.this.mBaseSimpleRecyclerClickListener.onBaseItemClick(v.getTag());
        }
    };
    public View.OnLongClickListener longClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            BaseSimpleAdapter.this.mBaseSimpleRecyclerClickListener.onBaseItemLongClick(v.getTag());
            return false;
        }
    };
    protected List<Item> mItems = new ArrayList<Item>();

    public void update(List<Item> items) {
        this.mItems = items;
        this.notifyDataSetChanged();
    }

    public int getItemViewType(int position) {
        return 0;
    }

    public abstract int getItemLayout();

    public abstract BaseViewHolder getViewHolder(View var1);

    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
        View view = layoutInflater.inflate(this.getItemLayout(), parent, false);
        return this.getViewHolder(view);
    }

    public void onBindViewHolder(BaseViewHolder holder, int position) {
        Item item = this.mItems.get(position);
        BaseViewHolder viewHolder = holder;
        viewHolder.populate(viewHolder, position, item);
    }

    public int getItemCount() {
        return this.mItems.size();
    }
}

