/*
 * Decompiled with CFR 0.152.
 */
package com.resources.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.v4.content.ContextCompat;
import android.util.Base64;
import com.resources.utils.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;

public class ImageUtils {
    private static final int IMAGE_SCALE_OPTION = 2;
    private static Uri targetResource = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;

    public static void showAlertDialog(Context context, String title, String message) {
        new AlertDialog.Builder(context).setTitle((CharSequence)title).setMessage((CharSequence)message).setPositiveButton((CharSequence)"Aceptar", null).show();
    }

    public static Bitmap UriToBitMap(Context context, Uri data) {
        Bitmap b = null;
        if (data != null) {
            try {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inSampleSize = 2;
                b = BitmapFactory.decodeStream((InputStream)context.getContentResolver().openInputStream(data), null, (BitmapFactory.Options)options);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return b;
    }

    public static Uri prepareImageFile(Context context, String imageFileName, String imageDescription) {
        ContentValues values = new ContentValues();
        values.put("title", imageFileName);
        if (imageDescription != null) {
            values.put("description", "Android Camera Image");
        }
        return context.getContentResolver().insert(targetResource, values);
    }

    public static String compressBitmapToBase64(Bitmap bitmap, int level) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, level, (OutputStream)byteArrayOutputStream);
        byte[] byteArray = byteArrayOutputStream.toByteArray();
        return Base64.encodeToString((byte[])byteArray, (int)0);
    }

    public static String bitmapToBase64(Bitmap bitmap) {
        return Base64.encodeToString((byte[])FileUtils.bitmapToByteArray(bitmap), (int)0);
    }

    public static Bitmap base64toBitmap(String encodedImage) {
        byte[] decodedString = Base64.decode((String)encodedImage, (int)0);
        return BitmapFactory.decodeByteArray((byte[])decodedString, (int)0, (int)decodedString.length);
    }

    public static Bitmap scaleBitmap(Bitmap bitmap, int wantedWidth, int wantedHeight) {
        Bitmap output = Bitmap.createBitmap((int)wantedWidth, (int)wantedHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Matrix m = new Matrix();
        m.setScale((float)wantedWidth / (float)bitmap.getWidth(), (float)wantedHeight / (float)bitmap.getHeight());
        canvas.drawBitmap(bitmap, m, new Paint());
        return output;
    }

    public static Bitmap getBitmap(Context context, int drawableId) {
        try {
            Drawable drawable = ContextCompat.getDrawable((Context)context, (int)drawableId);
            if (drawable instanceof BitmapDrawable) {
                return ((BitmapDrawable)drawable).getBitmap();
            }
            if (drawable instanceof VectorDrawable) {
                return ImageUtils.getBitmap((VectorDrawable)drawable);
            }
            throw new IllegalArgumentException("unsupported drawable type");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("unsupported drawable type");
        }
    }

    @TargetApi(value=21)
    protected static Bitmap getBitmap(VectorDrawable vectorDrawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)vectorDrawable.getIntrinsicWidth(), (int)vectorDrawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        vectorDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        vectorDrawable.draw(canvas);
        return bitmap;
    }

    public static Bitmap rotate(Bitmap b, int degrees) {
        if (degrees != 0 && b != null) {
            Matrix m = new Matrix();
            m.setRotate((float)degrees, (float)b.getWidth() / 2.0f, (float)b.getHeight() / 2.0f);
            Bitmap b2 = Bitmap.createBitmap((Bitmap)b, (int)0, (int)0, (int)b.getWidth(), (int)b.getHeight(), (Matrix)m, (boolean)true);
            if (b != b2) {
                b.recycle();
                b = b2;
            }
        }
        return b;
    }

    public static Bitmap toGrayScale(Bitmap bmpOriginal) {
        int height = bmpOriginal.getHeight();
        int width = bmpOriginal.getWidth();
        Bitmap bmpGrayscale = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(bmpOriginal, 0.0f, 0.0f, paint);
        return bmpGrayscale;
    }

    @SuppressLint(value={"NewApi", "Recycle"})
    public static String getFilePath(Context context, Uri uri) throws URISyntaxException {
        String selection = null;
        String[] selectionArgs = null;
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context.getApplicationContext(), (Uri)uri)) {
            if (ImageUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                return Environment.getExternalStorageDirectory() + "/" + split[1];
            }
            if (ImageUtils.isDownloadsDocument(uri)) {
                String id2 = DocumentsContract.getDocumentId((Uri)uri);
                uri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
            } else if (ImageUtils.isMediaDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("image".equals(type)) {
                    uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                } else if ("video".equals(type)) {
                    uri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                } else if ("audio".equals(type)) {
                    uri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                }
                selection = "_id=?";
                selectionArgs = new String[]{split[1]};
            }
        }
        if ("content".equalsIgnoreCase(uri.getScheme())) {
            String[] projection = new String[]{"_data"};
            Cursor cursor = null;
            try {
                cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
                assert (cursor != null);
                int column_index = cursor.getColumnIndexOrThrow("_data");
                if (cursor.moveToFirst()) {
                    return cursor.getString(column_index);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("file".equalsIgnoreCase(uri.getScheme())) {
            return uri.getPath();
        }
        return null;
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }
}

