/*
 * Decompiled with CFR 0.152.
 */
package com.resources.mvp;

import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.InflateException;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.resources.mvp.BasePresenter;

public abstract class BaseActivity
extends AppCompatActivity {
    public Toolbar mToolbar;
    private BasePresenter[] mPresenters;
    private BasePresenter mPresenter;
    private boolean toolbarEnabled;
    private boolean homeAsUpEnabled;

    protected void setToolbarEnabled(boolean enabled) {
        this.toolbarEnabled = enabled;
    }

    protected void setHomeAsUpEnabled(boolean enabled) {
        this.homeAsUpEnabled = enabled;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.toolbarEnabled = true;
        this.homeAsUpEnabled = true;
        this.mPresenters = this.getPresenters();
        this.mPresenter = this.getPresenter();
        if (this.mPresenters != null) {
            for (BasePresenter basePresenter : this.mPresenters) {
                if (basePresenter == null) continue;
                basePresenter.onCreate();
            }
        }
        if (this.mPresenter != null) {
            this.mPresenter.onCreate();
        }
    }

    protected BasePresenter getPresenter() {
        return null;
    }

    protected BasePresenter[] getPresenters() {
        return null;
    }

    public void setSubtitle(String subtitle) {
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setSubtitle((CharSequence)subtitle);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void setContentView(int layoutResID) {
        super.setContentView(layoutResID);
        if (this.toolbarEnabled) {
            View toolbar = this.findToolbar(this.findViewById(0x1020002));
            if (toolbar != null) {
                this.mToolbar = (Toolbar)toolbar;
                this.setupToolbar();
            } else {
                throw new InflateException("You must add a Toolbar on the Activity or setToolbarEnabled(false) before setContentView()");
            }
        }
    }

    private View findToolbar(View view) {
        if (view instanceof Toolbar) {
            return view;
        }
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                View child = ((ViewGroup)view).getChildAt(i);
                View possibleToolbar = this.findToolbar(child);
                if (possibleToolbar == null || !(possibleToolbar instanceof Toolbar)) continue;
                return possibleToolbar;
            }
        }
        return null;
    }

    protected void onStart() {
        super.onStart();
        if (this.mPresenters != null) {
            for (BasePresenter basePresenter : this.mPresenters) {
                if (basePresenter == null) continue;
                basePresenter.onStart();
            }
        }
        if (this.mPresenter != null) {
            this.mPresenter.onStart();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mPresenters != null) {
            for (BasePresenter basePresenter : this.mPresenters) {
                if (basePresenter == null) continue;
                basePresenter.onResume();
            }
        }
        if (this.mPresenter != null) {
            this.mPresenter.onResume();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mPresenters != null) {
            for (BasePresenter basePresenter : this.mPresenters) {
                if (basePresenter == null) continue;
                basePresenter.onPause();
            }
        }
        if (this.mPresenter != null) {
            this.mPresenter.onPause();
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.mPresenters != null) {
            for (BasePresenter basePresenter : this.mPresenters) {
                if (basePresenter == null) continue;
                basePresenter.onStop();
            }
        }
        if (this.mPresenter != null) {
            this.mPresenter.onStop();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mPresenters != null) {
            for (BasePresenter basePresenter : this.mPresenters) {
                if (basePresenter == null) continue;
                basePresenter.onDestroy();
            }
        }
        if (this.mPresenter != null) {
            this.mPresenter.onDestroy();
        }
    }

    private void setupToolbar() {
        this.setSupportActionBar(this.mToolbar);
        if (this.getSupportActionBar() != null && this.homeAsUpEnabled) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
    }
}

