/*
 * Decompiled with CFR 0.152.
 */
package com.resources.datamanager;

import android.content.Context;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.RealmModel;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;

public abstract class BaseDataManager {
    public Realm mRealm = Realm.getDefaultInstance();

    public static void init(Context context) {
        Realm.init((Context)context);
        byte[] key = new byte[64];
        new SecureRandom(key);
        RealmConfiguration realmConfiguration = new RealmConfiguration.Builder().deleteRealmIfMigrationNeeded().encryptionKey(key).build();
        Realm.setDefaultConfiguration((RealmConfiguration)realmConfiguration);
    }

    public void validateConnection() {
        if (this.mRealm == null || this.mRealm.isClosed()) {
            this.mRealm = Realm.getDefaultInstance();
        }
    }

    public void close() {
        if (this.mRealm != null && !this.mRealm.isClosed()) {
            this.mRealm.close();
        }
    }

    public void clearAll() {
        this.mRealm.executeTransaction(realm1 -> realm1.deleteAll());
    }

    public <T extends RealmModel> void findObject(Class<T> tClass, String id, ValidatorResult<T> validatorResult) {
        Object object = this.queryWhere(tClass).filter("id", id).findFirst();
        if (object != null) {
            validatorResult.result((RealmModel)tClass.cast(object));
        }
    }

    public <T extends RealmModel> void findByCodeObject(Class<T> tClass, String id, ValidatorResult<T> validatorResult) {
        Object object = this.queryWhere(tClass).filter("code", id).findFirst();
        if (object != null) {
            validatorResult.result((RealmModel)tClass.cast(object));
        }
    }

    public <T extends RealmModel> Query queryWhere(Class<T> tClass) {
        return new Query().create(tClass);
    }

    public <T extends RealmModel> T findObjectOfAttention(Class<T> tClass, String attentionId) {
        return new Query().create(tClass).filter("attention", attentionId).findFirst();
    }

    private <T extends RealmModel> ArrayList<T> findObjectsOfAttention(Class<T> tClass, String attentionId) {
        RealmResults objects = this.mRealm.where(tClass).equalTo("attention", attentionId).findAll();
        return new ArrayList(this.mRealm.copyFromRealm((Iterable)objects));
    }

    public class Query {
        private RealmQuery realmQuery;
        private String attrSorted = "";

        public <T extends RealmModel> Query create(Class<T> tClass) {
            BaseDataManager.this.validateConnection();
            this.realmQuery = BaseDataManager.this.mRealm.where(tClass);
            return this;
        }

        public Query filter(String filter, String value) {
            this.realmQuery.equalTo(filter, value);
            return this;
        }

        public Query filterWhereNot(String filter, String value) {
            this.realmQuery.notEqualTo(filter, value);
            return this;
        }

        public Query filter(String filter, boolean value) {
            this.realmQuery.equalTo(filter, Boolean.valueOf(value));
            return this;
        }

        public Query filter(String filter, Date value) {
            this.realmQuery.equalTo(filter, value);
            return this;
        }

        public Query between(String filter, Date valueOne, Date valueTwo) {
            this.realmQuery.between(filter, valueOne, valueTwo);
            return this;
        }

        public <T extends RealmModel> T findFirstId(String value) {
            RealmModel result = (RealmModel)this.realmQuery.equalTo("id", value).findFirst();
            return (T)(result != null ? BaseDataManager.this.mRealm.copyFromRealm(result) : null);
        }

        public <T extends RealmModel> T findFirst() {
            RealmModel result = (RealmModel)this.realmQuery.findFirst();
            return (T)(result != null ? BaseDataManager.this.mRealm.copyFromRealm(result) : null);
        }

        public void remove() {
            RealmResults results = this.realmQuery.findAll();
            if (results != null) {
                results.deleteAllFromRealm();
            }
        }

        public <T extends RealmModel> ArrayList<T> list() {
            return this.attrSorted.equals("") ? new ArrayList(BaseDataManager.this.mRealm.copyFromRealm((Iterable)this.realmQuery.findAll())) : new ArrayList(BaseDataManager.this.mRealm.copyFromRealm((Iterable)this.realmQuery.findAllSorted(this.attrSorted)));
        }

        public Query order(String attrSorted) {
            this.attrSorted = attrSorted;
            return this;
        }
    }

    public static interface ValidatorResult<T extends RealmModel> {
        public void result(T var1);
    }
}

