/*
 * Decompiled with CFR 0.152.
 */
package com.resources.view.CatalogEditText;

import android.content.Context;
import android.graphics.Canvas;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.example.resources.R;
import com.resources.utils.StringUtils;
import com.resources.view.CatalogEditText.CatalogObject;
import java.util.List;

public class CatalogEditText<T extends CatalogObject>
extends AppCompatEditText {
    public List<T> mItems;
    CharSequence mHint = this.getHint();
    OnCatalogSelectedListener<T> onCatalogSelectedListener;
    ListAdapter mSpinnerAdapter;
    private T mSelectedObject;

    public CatalogEditText(Context context) {
        super(context);
    }

    public CatalogEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CatalogEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setCatalogs(List<T> catalogs) {
        this.mItems = catalogs;
        this.setAdapter((ListAdapter)new ArrayAdapter(this.getContext(), 17367043, this.mItems));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.setFocusable(false);
        this.setClickable(true);
    }

    public void setAdapter(ListAdapter adapter) {
        this.mSpinnerAdapter = adapter;
        this.configureOnClickListener();
    }

    private void configureOnClickListener() {
        this.setOnClickListener(view -> {
            AlertDialog.Builder builder = new AlertDialog.Builder(view.getContext());
            View dialogView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_catalog_edit_text, null);
            TextView titleTextView = (TextView)dialogView.findViewById(R.id.v_catalog_edit_text_title);
            ListView listView = (ListView)dialogView.findViewById(R.id.v_catalog_edit_text_list);
            EditText searchEditText = (EditText)dialogView.findViewById(R.id.v_catalog_edit_text_search);
            titleTextView.setText(this.mHint);
            listView.setAdapter(this.mSpinnerAdapter);
            builder.setView(dialogView);
            builder.setPositiveButton(R.string.dialog_cancel, null);
            AlertDialog dialog = builder.create();
            listView.setOnItemClickListener((parent, view1, position, id2) -> {
                CatalogObject object = (CatalogObject)listView.getAdapter().getItem(position);
                this.mSelectedObject = object;
                this.setText(object.toString());
                if (this.onCatalogSelectedListener != null) {
                    this.onCatalogSelectedListener.onItemCatalogSelectedListener(object, position);
                }
                dialog.dismiss();
            });
            dialog.show();
        });
    }

    public void setOnCatalogSelectedListener(OnCatalogSelectedListener<T> onCatalogSelectedListener) {
        this.onCatalogSelectedListener = onCatalogSelectedListener;
    }

    public void setSelectedObject(T object) {
        if (object != null) {
            this.mSelectedObject = object;
            this.setText(StringUtils.stringNotEmpty(object.toString()));
        }
    }

    public T getSelectedValue() {
        return this.mSelectedObject;
    }

    public static interface OnCatalogSelectedListener<T> {
        public void onItemCatalogSelectedListener(T var1, int var2);
    }
}

