/*
 * Decompiled with CFR 0.152.
 */
package com.resources.utils.validators;

import android.widget.RadioButton;
import com.resources.utils.validators.FormValidator;

public class RadioButtonGroupValidator
extends FormValidator.Validator {
    private final RadioButton radioButton;
    private final FormValidator.Validator[] validators;
    private final boolean showAllErrors;

    public RadioButtonGroupValidator(RadioButton radioButton, FormValidator.Validator[] validators, boolean showAllErrors) {
        this.radioButton = radioButton;
        this.validators = validators;
        this.showAllErrors = showAllErrors;
    }

    @Override
    boolean isValid() {
        boolean valid = true;
        if (this.radioButton.isChecked()) {
            for (FormValidator.Validator validator : this.validators) {
                validator.setContext(this.context);
                if (validator.isValid()) continue;
                valid = false;
            }
        }
        return valid;
    }

    @Override
    void showError() {
        if (this.showAllErrors) {
            for (FormValidator.Validator validator : this.validators) {
                if (validator.isValid()) continue;
                validator.showError();
            }
        } else {
            for (FormValidator.Validator validator : this.validators) {
                if (validator.isValid()) continue;
                validator.showError();
                break;
            }
        }
    }

    @Override
    void stopError() {
        for (FormValidator.Validator validator : this.validators) {
            if (!validator.isValid()) continue;
            validator.stopError();
        }
    }
}

